/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import de.flapdoodle.embed.mongo.spring.autoconfigure.MongoClientAction;
import java.util.ArrayList;
import java.util.Objects;

final class ImmutableCredentials
extends MongoClientAction.Credentials {
    private final String database;
    private final String username;
    private final String password;

    private ImmutableCredentials(String database, String username, String password) {
        this.database = database;
        this.username = username;
        this.password = password;
    }

    @Override
    public String database() {
        return this.database;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    public final ImmutableCredentials withDatabase(String value) {
        String newValue = Objects.requireNonNull(value, "database");
        if (this.database.equals(newValue)) {
            return this;
        }
        return new ImmutableCredentials(newValue, this.username, this.password);
    }

    public final ImmutableCredentials withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableCredentials(this.database, newValue, this.password);
    }

    public final ImmutableCredentials withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return new ImmutableCredentials(this.database, this.username, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCredentials && this.equalTo(0, (ImmutableCredentials)another);
    }

    private boolean equalTo(int synthetic, ImmutableCredentials another) {
        return this.database.equals(another.database) && this.username.equals(another.username) && this.password.equals(another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.database.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.password.hashCode();
        return h;
    }

    public String toString() {
        return "Credentials{database=" + this.database + ", username=" + this.username + ", password=" + this.password + "}";
    }

    public static ImmutableCredentials copyOf(MongoClientAction.Credentials instance) {
        if (instance instanceof ImmutableCredentials) {
            return (ImmutableCredentials)instance;
        }
        return ImmutableCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DATABASE = 1L;
        private static final long INIT_BIT_USERNAME = 2L;
        private static final long INIT_BIT_PASSWORD = 4L;
        private long initBits = 7L;
        private String database;
        private String username;
        private String password;

        private Builder() {
        }

        public final Builder from(MongoClientAction.Credentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.database(instance.database());
            this.username(instance.username());
            this.password(instance.password());
            return this;
        }

        public final Builder database(String database) {
            this.database = Objects.requireNonNull(database, "database");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableCredentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCredentials(this.database, this.username, this.password);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("database");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build Credentials, some of required attributes are not set " + attributes;
        }
    }
}

