/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.HasExplanation;
import de.flapdoodle.embed.mongo.packageresolver.HasMongotoolsPackage;
import de.flapdoodle.embed.mongo.packageresolver.ImmutableUrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Version;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class UrlTemplatePackageResolver
implements PackageFinder,
HasExplanation {
    protected abstract ArchiveType archiveType();

    protected abstract FileSet fileSet();

    abstract String urlTemplate();

    @Value.Default
    protected boolean isDevVersion() {
        return false;
    }

    @Override
    public Optional<Package> packageFor(Distribution distribution) {
        String path = UrlTemplatePackageResolver.render(this.urlTemplate(), distribution);
        return Optional.of(this.isDevVersion() ? Package.of((ArchiveType)this.archiveType(), (FileSet)this.fileSet(), (String)path, (String)"Development Version / Release Candidate") : Package.of((ArchiveType)this.archiveType(), (FileSet)this.fileSet(), (String)path));
    }

    @Override
    @Value.Auxiliary
    public String explain() {
        return "url=" + this.urlTemplate() + " (" + this.archiveType().name() + (this.isDevVersion() ? "(DEV)" : "") + ")";
    }

    private static String render(String urlTemplate, Distribution distribution) {
        String version = distribution.version().asInDownloadPath();
        String withVersion = urlTemplate.replace("{version}", version);
        Optional<String> toolsVersion = Optional.of(distribution.version()).flatMap(it -> it instanceof HasMongotoolsPackage ? Optional.of((HasMongotoolsPackage)it) : Optional.empty()).flatMap(HasMongotoolsPackage::mongotoolsVersion).map(Version::asInDownloadPath);
        String withOrWithoutToolsVersion = toolsVersion.isPresent() ? withVersion.replace("{tools.version}", toolsVersion.get()) : withVersion;
        return withOrWithoutToolsVersion;
    }

    public static ImmutableUrlTemplatePackageResolver.Builder builder() {
        return ImmutableUrlTemplatePackageResolver.builder();
    }
}

