/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.reactive;

import de.codecentric.boot.admin.server.web.AdminController;
import de.codecentric.boot.admin.server.web.PathUtils;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;

public class AdminControllerHandlerMapping
extends RequestMappingHandlerMapping {
    private final String adminContextPath;

    public AdminControllerHandlerMapping(String adminContextPath) {
        this.adminContextPath = adminContextPath;
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotatedElementUtils.hasAnnotation(beanType, AdminController.class);
    }

    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        super.registerHandlerMethod(handler, method, this.withPrefix(mapping));
    }

    private RequestMappingInfo withPrefix(RequestMappingInfo mapping) {
        if (!StringUtils.hasText((String)this.adminContextPath)) {
            return mapping;
        }
        return mapping.mutate().paths(this.withNewPatterns(mapping.getPatternsCondition())).build();
    }

    private String[] withNewPatterns(PatternsRequestCondition patternsRequestCondition) {
        return (String[])patternsRequestCondition.getPatterns().stream().map(pattern -> PathUtils.normalizePath(this.adminContextPath + String.valueOf(pattern))).toArray(String[]::new);
    }
}

