/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.filter.AbstractContentNotifier;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class MattermostNotifier
extends AbstractContentNotifier {
    private static final String DEFAULT_MESSAGE = "**#{name}** (#{id}) is **#{status}**";
    private RestTemplate restTemplate;
    private @Nullable URI apiUrl;
    private @Nullable String botAccessToken;
    private @Nullable String channelId;

    public MattermostNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        if (this.apiUrl == null) {
            return Mono.error((Throwable)new IllegalStateException("'url' must not be null."));
        }
        return Mono.fromRunnable(() -> this.restTemplate.postForEntity(this.apiUrl, this.createMessage(event, instance), Void.class));
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    protected Object createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, Object> messageJson = new HashMap<String, Object>();
        if (this.channelId != null) {
            messageJson.put("channel_id", this.channelId);
        }
        HashMap<String, String> attachments = new HashMap<String, String>();
        attachments.put("text", this.createContent(event, instance));
        attachments.put("fallback", this.createContent(event, instance));
        attachments.put("color", this.getColor(event));
        HashMap props = new HashMap();
        props.put("attachments", Collections.singletonList(attachments));
        messageJson.put("props", props);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(this.botAccessToken);
        return new HttpEntity(messageJson, headers);
    }

    @Override
    protected String getDefaultMessage() {
        return DEFAULT_MESSAGE;
    }

    protected String getColor(InstanceEvent event) {
        if (event instanceof InstanceStatusChangedEvent) {
            InstanceStatusChangedEvent statusChangedEvent = (InstanceStatusChangedEvent)event;
            return "UP".equals(statusChangedEvent.getStatusInfo().getStatus()) ? "#2eb885" : "#a30100";
        }
        return "#439FE0";
    }

    public @Nullable URI getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(@Nullable URI apiUrl) {
        this.apiUrl = apiUrl;
    }

    public @Nullable String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(@Nullable String channelId) {
        this.channelId = channelId;
    }

    public @Nullable String getBotAccessToken() {
        return this.botAccessToken;
    }

    public void setBotAccessToken(@Nullable String botAccessToken) {
        this.botAccessToken = botAccessToken;
    }
}

