/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.utils.jackson;

import de.codecentric.boot.admin.server.domain.values.Registration;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.deser.std.StdDeserializer;

public class RegistrationDeserializer
extends StdDeserializer<Registration> {
    public RegistrationDeserializer() {
        super(Registration.class);
    }

    public Registration deserialize(JsonParser p, DeserializationContext ctxt) {
        JsonNode node = (JsonNode)p.readValueAsTree();
        Registration.Builder builder = Registration.builder();
        builder.name(this.firstNonNullAsString(node, "name"));
        if (node.hasNonNull("url")) {
            String url = this.firstNonNullAsString(node, "url");
            builder.healthUrl(url.replaceFirst("/+$", "") + "/health").managementUrl(url);
        } else {
            builder.healthUrl(this.firstNonNullAsString(node, "healthUrl", "health_url"));
            builder.managementUrl(this.firstNonNullAsString(node, "managementUrl", "management_url"));
            builder.serviceUrl(this.firstNonNullAsString(node, "serviceUrl", "service_url"));
        }
        if (node.has("metadata")) {
            node.get("metadata").properties().forEach(entry -> builder.metadata((String)entry.getKey(), ((JsonNode)entry.getValue()).asString()));
        }
        builder.source(this.firstNonNullAsString(node, "source"));
        return builder.build();
    }

    private String firstNonNullAsString(JsonNode node, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            if (!node.hasNonNull(fieldName)) continue;
            return node.get(fieldName).asString();
        }
        return null;
    }
}

