/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.filter.AbstractContentNotifier;
import java.net.URI;
import java.util.HashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class DiscordNotifier
extends AbstractContentNotifier {
    private static final String DEFAULT_MESSAGE = "*#{name}* (#{id}) is *#{status}*";
    private RestTemplate restTemplate;
    private @Nullable URI webhookUrl;
    private boolean tts = false;
    private @Nullable String username;
    private @Nullable String avatarUrl;

    public DiscordNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        if (this.webhookUrl == null) {
            return Mono.error((Throwable)new IllegalStateException("'webhookUrl' must not be null."));
        }
        return Mono.fromRunnable(() -> this.restTemplate.postForEntity(this.webhookUrl, this.createDiscordNotification(event, instance), Void.class));
    }

    protected Object createDiscordNotification(InstanceEvent event, Instance instance) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("content", this.createContent(event, instance));
        body.put("tts", this.tts);
        if (this.avatarUrl != null) {
            body.put("avatar_url", this.avatarUrl);
        }
        if (this.username != null) {
            body.put("username", this.username);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("User-Agent", "RestTemplate");
        return new HttpEntity(body, headers);
    }

    @Override
    protected String getDefaultMessage() {
        return DEFAULT_MESSAGE;
    }

    public @Nullable URI getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(@Nullable URI webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public boolean isTts() {
        return this.tts;
    }

    public void setTts(boolean tts) {
        this.tts = tts;
    }

    public @Nullable String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public @Nullable String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(@Nullable String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

