/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client.cookies;

import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.web.client.cookies.PerInstanceCookieStore;
import de.codecentric.boot.admin.server.web.client.exception.InstanceWebClientException;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;

public class JdkPerInstanceCookieStore
implements PerInstanceCookieStore {
    private static final String REQ_COOKIE_HEADER_KEY = "Cookie";
    private final Map<InstanceId, CookieHandler> cookieHandlerRegistry = new ConcurrentHashMap<InstanceId, CookieHandler>();
    private final CookiePolicy cookiePolicy;

    public JdkPerInstanceCookieStore() {
        this(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
    }

    public JdkPerInstanceCookieStore(CookiePolicy cookiePolicy) {
        Assert.notNull((Object)cookiePolicy, (String)"'cookiePolicy' must not be null");
        this.cookiePolicy = cookiePolicy;
    }

    @Override
    public MultiValueMap<String, String> get(InstanceId instanceId, URI requestUri, MultiValueMap<String, String> requestHeaders) {
        try {
            List<String> rawCookies = this.getCookieHandler(instanceId).get(requestUri, (Map<String, List<String>>)requestHeaders).get(REQ_COOKIE_HEADER_KEY);
            return (MultiValueMap)Optional.ofNullable(rawCookies).map(rcList -> rcList.stream().map(rc -> rc.split("=", 2)).collect(LinkedMultiValueMap::new, (map, nv) -> map.add((Object)nv[0], (Object)nv[1]), MultiValueMapAdapter::addAll)).orElseGet(LinkedMultiValueMap::new);
        }
        catch (IOException ioe) {
            throw new InstanceWebClientException("Could not get cookies from store.", ioe);
        }
    }

    @Override
    public void put(InstanceId instanceId, URI requestUrl, MultiValueMap<String, String> headers) {
        try {
            this.getCookieHandler(instanceId).put(requestUrl, (Map<String, List<String>>)headers);
        }
        catch (IOException ioe) {
            throw new InstanceWebClientException("Could not set cookies to store.", ioe);
        }
    }

    @Override
    public void cleanupInstance(InstanceId instanceId) {
        this.cookieHandlerRegistry.computeIfPresent(instanceId, (id, ch) -> null);
    }

    protected CookieHandler getCookieHandler(InstanceId instanceId) {
        return this.cookieHandlerRegistry.computeIfAbsent(instanceId, this::createCookieHandler);
    }

    protected CookieHandler createCookieHandler(InstanceId instanceId) {
        return new CookieManager(null, this.cookiePolicy);
    }
}

