/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.config;

import de.codecentric.boot.admin.server.config.AdminServerMarkerConfiguration;
import de.codecentric.boot.admin.server.config.AdminServerProperties;
import de.codecentric.boot.admin.server.config.AdminServerWebConfiguration;
import de.codecentric.boot.admin.server.config.SpringBootAdminServerEnabledCondition;
import de.codecentric.boot.admin.server.notify.filter.web.NotificationFilterController;
import de.codecentric.boot.admin.server.ui.config.AdminServerUiProperties;
import de.codecentric.boot.admin.server.ui.config.CssColorUtils;
import de.codecentric.boot.admin.server.ui.extensions.UiExtensions;
import de.codecentric.boot.admin.server.ui.extensions.UiExtensionsScanner;
import de.codecentric.boot.admin.server.ui.extensions.UiRoutesScanner;
import de.codecentric.boot.admin.server.ui.web.HomepageForwardingFilterConfig;
import de.codecentric.boot.admin.server.ui.web.UiController;
import de.codecentric.boot.admin.server.ui.web.reactive.HomepageForwardingFilter;
import de.codecentric.boot.admin.server.web.PathUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.thymeleaf.spring6.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templatemode.TemplateMode;

@Configuration(proxyBeanMethods=false)
@Conditional(value={SpringBootAdminServerEnabledCondition.class})
@ConditionalOnBean(value={AdminServerMarkerConfiguration.Marker.class})
@AutoConfigureAfter(value={AdminServerWebConfiguration.class})
@EnableConfigurationProperties(value={AdminServerUiProperties.class})
public class AdminServerUiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AdminServerUiAutoConfiguration.class);
    private static final List<String> DEFAULT_UI_ROUTES = Arrays.asList("/about/**", "/applications/**", "/instances/**", "/journal/**", "/wallboard/**", "/external/**");
    private static final List<String> DEFAULT_UI_ROUTE_EXCLUDES = Arrays.asList("/extensions/**", "/instances/*/actuator/**");
    private final AdminServerUiProperties adminUi;
    private final AdminServerProperties adminServer;
    private final ApplicationContext applicationContext;

    public AdminServerUiAutoConfiguration(AdminServerUiProperties adminUi, AdminServerProperties serverProperties, ApplicationContext applicationContext) {
        this.adminUi = adminUi;
        this.adminServer = serverProperties;
        this.applicationContext = applicationContext;
    }

    @Bean
    public CssColorUtils cssColorUtils() {
        return new CssColorUtils();
    }

    @Bean
    @ConditionalOnMissingBean
    public UiController homeUiController(UiExtensions uiExtensions) throws IOException {
        List<String> extensionRoutes = new UiRoutesScanner((ResourcePatternResolver)this.applicationContext).scan(this.adminUi.getExtensionResourceLocations());
        List<String> routes = Stream.concat(DEFAULT_UI_ROUTES.stream(), extensionRoutes.stream()).toList();
        UiController.Settings uiSettings = UiController.Settings.builder().brand(this.adminUi.getBrand()).title(this.adminUi.getTitle()).loginIcon(this.adminUi.getLoginIcon()).favicon(this.adminUi.getFavicon()).faviconDanger(this.adminUi.getFaviconDanger()).enableToasts(this.adminUi.getEnableToasts()).hideInstanceUrl(this.adminUi.getHideInstanceUrl()).disableInstanceUrl(this.adminUi.getDisableInstanceUrl()).notificationFilterEnabled(!this.applicationContext.getBeansOfType(NotificationFilterController.class).isEmpty()).routes(routes).rememberMeEnabled(this.adminUi.isRememberMeEnabled()).availableLanguages(this.adminUi.getAvailableLanguages()).externalViews(this.adminUi.getExternalViews()).pollTimer(this.adminUi.getPollTimer()).viewSettings(this.adminUi.getViewSettings()).theme(this.adminUi.getTheme()).build();
        String publicUrl = this.adminUi.getPublicUrl() != null ? this.adminUi.getPublicUrl() : this.adminServer.getContextPath();
        return new UiController(publicUrl, uiExtensions, uiSettings);
    }

    @Bean
    UiExtensions uiExtensions() throws IOException {
        UiExtensionsScanner scanner = new UiExtensionsScanner((ResourcePatternResolver)this.applicationContext);
        UiExtensions uiExtensions = scanner.scan(this.adminUi.getExtensionResourceLocations());
        uiExtensions.forEach(e -> log.info("Loaded Spring Boot Admin UI Extension: {}", e));
        return uiExtensions;
    }

    @Bean
    public SpringResourceTemplateResolver adminTemplateResolver() {
        SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
        resolver.setApplicationContext(this.applicationContext);
        resolver.setPrefix(this.adminUi.getTemplateLocation());
        resolver.setSuffix(".html");
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resolver.setCacheable(this.adminUi.isCacheTemplates());
        resolver.setOrder(Integer.valueOf(10));
        resolver.setCheckExistence(true);
        return resolver;
    }

    static String normalizeHomepageUrl(String homepage) {
        if (!"/".equals(homepage)) {
            homepage = PathUtils.normalizePath((String)homepage);
        }
        return homepage;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class ServletUiConfiguration {

        @Configuration(proxyBeanMethods=false)
        public static class AdminUiWebMvcConfig
        implements WebMvcConfigurer {
            private final AdminServerUiProperties adminUi;
            private final AdminServerProperties adminServer;
            private final ApplicationContext applicationContext;

            public AdminUiWebMvcConfig(AdminServerUiProperties adminUi, AdminServerProperties adminServer, ApplicationContext applicationContext) {
                this.adminUi = adminUi;
                this.adminServer = adminServer;
                this.applicationContext = applicationContext;
            }

            @Bean
            public HomepageForwardingFilterConfig homepageForwardingFilterConfig() throws IOException {
                String homepage = AdminServerUiAutoConfiguration.normalizeHomepageUrl(this.adminServer.path("/"));
                List<String> extensionRoutes = new UiRoutesScanner((ResourcePatternResolver)this.applicationContext).scan(this.adminUi.getExtensionResourceLocations());
                List<String> routesIncludes = Stream.concat(DEFAULT_UI_ROUTES.stream(), Stream.concat(extensionRoutes.stream(), Stream.of("/"))).map(arg_0 -> ((AdminServerProperties)this.adminServer).path(arg_0)).toList();
                List<String> routesExcludes = Stream.concat(DEFAULT_UI_ROUTE_EXCLUDES.stream(), this.adminUi.getAdditionalRouteExcludes().stream()).map(arg_0 -> ((AdminServerProperties)this.adminServer).path(arg_0)).toList();
                return new HomepageForwardingFilterConfig(homepage, routesIncludes, routesExcludes);
            }

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{this.adminServer.path("/**")}).addResourceLocations(this.adminUi.getResourceLocations()).setCacheControl(this.adminUi.getCache().toCacheControl());
                registry.addResourceHandler(new String[]{this.adminServer.path("/extensions/**")}).addResourceLocations(this.adminUi.getExtensionResourceLocations()).setCacheControl(this.adminUi.getCache().toCacheControl());
            }

            @Bean
            @ConditionalOnMissingBean
            public de.codecentric.boot.admin.server.ui.web.servlet.HomepageForwardingFilter homepageForwardFilter(HomepageForwardingFilterConfig homepageForwardingFilterConfig) {
                return new de.codecentric.boot.admin.server.ui.web.servlet.HomepageForwardingFilter(homepageForwardingFilterConfig);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class ReactiveUiConfiguration {

        @Configuration(proxyBeanMethods=false)
        public static class AdminUiWebfluxConfig
        implements WebFluxConfigurer {
            private final AdminServerUiProperties adminUi;
            private final AdminServerProperties adminServer;
            private final WebFluxProperties webFluxProperties;
            private final ApplicationContext applicationContext;

            public AdminUiWebfluxConfig(AdminServerUiProperties adminUi, AdminServerProperties adminServer, WebFluxProperties webFluxProperties, ApplicationContext applicationContext) {
                this.adminUi = adminUi;
                this.adminServer = adminServer;
                this.webFluxProperties = webFluxProperties;
                this.applicationContext = applicationContext;
            }

            @Bean
            public HomepageForwardingFilterConfig homepageForwardingFilterConfig() throws IOException {
                String webFluxBasePath = this.webFluxProperties.getBasePath();
                boolean webfluxBasePathSet = webFluxBasePath != null;
                String homepage = AdminServerUiAutoConfiguration.normalizeHomepageUrl((String)(webfluxBasePathSet ? webFluxBasePath + "/" : this.adminServer.path("/")));
                List<String> extensionRoutes = new UiRoutesScanner((ResourcePatternResolver)this.applicationContext).scan(this.adminUi.getExtensionResourceLocations());
                List<String> routesIncludes = Stream.concat(DEFAULT_UI_ROUTES.stream(), extensionRoutes.stream()).map(path -> webfluxBasePathSet ? webFluxBasePath + path : this.adminServer.path(path)).collect(Collectors.toList());
                routesIncludes.add("");
                List<String> routesExcludes = Stream.concat(DEFAULT_UI_ROUTE_EXCLUDES.stream(), this.adminUi.getAdditionalRouteExcludes().stream()).map(path -> webfluxBasePathSet ? webFluxBasePath + path : this.adminServer.path(path)).toList();
                return new HomepageForwardingFilterConfig(homepage, routesIncludes, routesExcludes);
            }

            public void addResourceHandlers(org.springframework.web.reactive.config.ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{this.adminServer.path("/**")}).addResourceLocations(this.adminUi.getResourceLocations()).setCacheControl(this.adminUi.getCache().toCacheControl()).setMediaTypes(Map.of("js", new MediaType("application", "javascript")));
                registry.addResourceHandler(new String[]{this.adminServer.path("/extensions/**")}).addResourceLocations(this.adminUi.getExtensionResourceLocations()).setCacheControl(this.adminUi.getCache().toCacheControl()).setMediaTypes(Map.of("js", new MediaType("application", "javascript")));
            }

            @Bean
            @ConditionalOnMissingBean
            public HomepageForwardingFilter homepageForwardFilter(HomepageForwardingFilterConfig homepageForwardingFilterConfig) {
                return new HomepageForwardingFilter(homepageForwardingFilterConfig);
            }
        }
    }
}

