/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.cloud.discovery;

import de.codecentric.boot.admin.server.cloud.discovery.DefaultServiceInstanceConverter;
import de.codecentric.boot.admin.server.cloud.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.domain.values.Registration;
import de.codecentric.boot.admin.server.services.InstanceRegistry;
import de.codecentric.boot.admin.server.web.client.RefreshInstancesEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.event.ParentHeartbeatEvent;
import org.springframework.context.event.EventListener;
import org.springframework.util.PatternMatchUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InstanceDiscoveryListener {
    private static final Logger log = LoggerFactory.getLogger(InstanceDiscoveryListener.class);
    private static final String SOURCE = "discovery";
    private final DiscoveryClient discoveryClient;
    private final InstanceRegistry registry;
    private final InstanceRepository repository;
    private final HeartbeatMonitor monitor = new HeartbeatMonitor();
    private ServiceInstanceConverter converter = new DefaultServiceInstanceConverter();
    private Set<String> ignoredServices = new HashSet<String>();
    private Set<String> services = new HashSet<String>(Collections.singletonList("*"));
    private Map<String, String> instancesMetadata = new HashMap<String, String>();
    private Map<String, String> ignoredInstancesMetadata = new HashMap<String, String>();

    public InstanceDiscoveryListener(DiscoveryClient discoveryClient, InstanceRegistry registry, InstanceRepository repository) {
        this.discoveryClient = discoveryClient;
        this.registry = registry;
        this.repository = repository;
    }

    @EventListener
    public void onApplicationReady(ApplicationReadyEvent event) {
        this.discover();
    }

    @EventListener
    public void onInstanceRegistered(InstanceRegisteredEvent<?> event) {
        this.discover();
    }

    @EventListener
    public void onRefreshInstances(RefreshInstancesEvent event) {
        this.discover();
    }

    @EventListener
    public void onParentHeartbeat(ParentHeartbeatEvent event) {
        this.discoverIfNeeded(event.getValue());
    }

    @EventListener
    public void onApplicationEvent(HeartbeatEvent event) {
        this.discoverIfNeeded(event.getValue());
    }

    private void discoverIfNeeded(Object value) {
        if (this.monitor.update(value)) {
            this.discover();
        }
    }

    protected void discover() {
        log.debug("Discovering new instances from DiscoveryClient");
        Flux.fromIterable((Iterable)this.discoveryClient.getServices()).filter(this::shouldRegisterService).flatMapIterable(arg_0 -> ((DiscoveryClient)this.discoveryClient).getInstances(arg_0)).filter(this::shouldRegisterInstanceBasedOnMetadata).flatMap(this::registerInstance).collect(Collectors.toSet()).flatMap(this::removeStaleInstances).subscribe(v -> {}, ex -> log.error("Unexpected error.", ex));
    }

    protected Mono<Void> removeStaleInstances(Set<InstanceId> registeredInstanceIds) {
        return this.repository.findAll().filter(Instance::isRegistered).filter(instance -> SOURCE.equals(instance.getRegistration().getSource())).map(Instance::getId).filter(id -> !registeredInstanceIds.contains(id)).doOnNext(id -> log.info("Instance '{}' missing in DiscoveryClient services and will be removed.", id)).flatMap(arg_0 -> ((InstanceRegistry)this.registry).deregister(arg_0)).then();
    }

    protected boolean shouldRegisterService(String serviceId) {
        boolean shouldRegister;
        boolean bl = shouldRegister = this.matchesPattern(serviceId, this.services) && !this.matchesPattern(serviceId, this.ignoredServices);
        if (!shouldRegister) {
            log.debug("Ignoring service '{}' from discovery.", (Object)serviceId);
        }
        return shouldRegister;
    }

    protected boolean matchesPattern(String serviceId, Set<String> patterns) {
        return patterns.stream().anyMatch(pattern -> PatternMatchUtils.simpleMatch((String)pattern.toLowerCase(), (String)serviceId.toLowerCase()));
    }

    protected boolean shouldRegisterInstanceBasedOnMetadata(ServiceInstance instance) {
        boolean shouldRegister;
        boolean bl = shouldRegister = this.isInstanceAllowedBasedOnMetadata(instance) && !this.isInstanceIgnoredBasedOnMetadata(instance);
        if (!shouldRegister) {
            log.debug("Ignoring instance '{}' of '{}' service from discovery based on metadata.", (Object)instance.getInstanceId(), (Object)instance.getServiceId());
        }
        return shouldRegister;
    }

    protected Mono<InstanceId> registerInstance(ServiceInstance instance) {
        try {
            Registration registration = this.converter.convert(instance).toBuilder().source(SOURCE).build();
            log.debug("Registering discovered instance {}", (Object)registration);
            return this.registry.register(registration);
        }
        catch (Exception ex) {
            log.error("Couldn't register instance for discovered instance ({})", (Object)this.toString(instance), (Object)ex);
            return Mono.empty();
        }
    }

    protected String toString(ServiceInstance instance) {
        String httpScheme = instance.isSecure() ? "https" : "http";
        return String.format("serviceId=%s, instanceId=%s, url= %s://%s:%d", instance.getServiceId(), instance.getInstanceId(), instance.getScheme() != null ? instance.getScheme() : httpScheme, instance.getHost(), instance.getPort());
    }

    public void setConverter(ServiceInstanceConverter converter) {
        this.converter = converter;
    }

    public void setIgnoredServices(Set<String> ignoredServices) {
        this.ignoredServices = ignoredServices;
    }

    public Set<String> getIgnoredServices() {
        return this.ignoredServices;
    }

    public Set<String> getServices() {
        return this.services;
    }

    public void setServices(Set<String> services) {
        this.services = services;
    }

    public Map<String, String> getInstancesMetadata() {
        return this.instancesMetadata;
    }

    public void setInstancesMetadata(Map<String, String> instancesMetadata) {
        this.instancesMetadata = instancesMetadata;
    }

    public Map<String, String> getIgnoredInstancesMetadata() {
        return this.ignoredInstancesMetadata;
    }

    public void setIgnoredInstancesMetadata(Map<String, String> ignoredInstancesMetadata) {
        this.ignoredInstancesMetadata = ignoredInstancesMetadata;
    }

    private boolean isInstanceAllowedBasedOnMetadata(ServiceInstance instance) {
        if (this.instancesMetadata.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> entry : instance.getMetadata().entrySet()) {
            if (!this.isMapContainsEntry(this.instancesMetadata, entry)) continue;
            return true;
        }
        return false;
    }

    private boolean isInstanceIgnoredBasedOnMetadata(ServiceInstance instance) {
        if (this.ignoredInstancesMetadata.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> entry : instance.getMetadata().entrySet()) {
            if (!this.isMapContainsEntry(this.ignoredInstancesMetadata, entry)) continue;
            return true;
        }
        return false;
    }

    private boolean isMapContainsEntry(Map<String, String> map, Map.Entry<String, String> entry) {
        String value = map.get(entry.getKey());
        return value != null && value.equals(entry.getValue());
    }
}

