/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import de.codecentric.boot.admin.client.registration.ApplicationRegistrator;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class RegistrationApplicationListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistrationApplicationListener.class);
    private final ApplicationRegistrator registrator;
    private final ThreadPoolTaskScheduler taskScheduler;
    private boolean autoDeregister = false;
    private boolean autoRegister = true;
    private Duration registerPeriod = Duration.ofSeconds(10L);
    @Nullable
    private volatile ScheduledFuture<?> scheduledTask;

    public RegistrationApplicationListener(ApplicationRegistrator registrator) {
        this(registrator, RegistrationApplicationListener.registrationTaskScheduler());
    }

    private static ThreadPoolTaskScheduler registrationTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(1);
        taskScheduler.setRemoveOnCancelPolicy(true);
        taskScheduler.setThreadNamePrefix("registrationTask");
        return taskScheduler;
    }

    RegistrationApplicationListener(ApplicationRegistrator registrator, ThreadPoolTaskScheduler taskScheduler) {
        this.registrator = registrator;
        this.taskScheduler = taskScheduler;
    }

    @EventListener
    @Order(value=0x7FFFFFFF)
    public void onApplicationReady(ApplicationReadyEvent event) {
        if (this.autoRegister) {
            this.startRegisterTask();
        }
    }

    @EventListener
    @Order(value=0x7FFFFFFF)
    public void onClosedContext(ContextClosedEvent event) {
        if (event.getApplicationContext().getParent() == null || "bootstrap".equals(event.getApplicationContext().getParent().getId())) {
            this.stopRegisterTask();
            if (this.autoDeregister) {
                this.registrator.deregister();
            }
        }
    }

    public void startRegisterTask() {
        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
            return;
        }
        this.scheduledTask = this.taskScheduler.scheduleAtFixedRate(this.registrator::register, this.registerPeriod);
        LOGGER.debug("Scheduled registration task for every {}ms", (Object)this.registerPeriod.toMillis());
    }

    public void stopRegisterTask() {
        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
            this.scheduledTask.cancel(true);
            LOGGER.debug("Canceled registration task");
        }
    }

    public void setAutoDeregister(boolean autoDeregister) {
        this.autoDeregister = autoDeregister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public void setRegisterPeriod(Duration registerPeriod) {
        this.registerPeriod = registerPeriod;
    }

    public void afterPropertiesSet() {
        this.taskScheduler.afterPropertiesSet();
    }

    public void destroy() {
        this.taskScheduler.destroy();
    }
}

