/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.advice.filter;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Proxy;
import org.springframework.aop.ClassFilter;

public class RepositoryClassFilter
implements ClassFilter {
    private static final String SPRING_DATA_REPOSITORY_CLASS_REF = "org.springframework.data.repository.Repository";
    private final Class<?> repositoryClass = Class.forName("org.springframework.data.repository.Repository");

    public boolean matches(@Nonnull Class<?> clazz) {
        return Proxy.isProxyClass(clazz) && this.repositoryClass.isAssignableFrom(clazz);
    }

    public String toString() {
        return "RepositoryClassFilter{repositoryClass=org.springframework.data.repository.Repository}";
    }

    public final boolean equals(Object other) {
        return other instanceof RepositoryClassFilter;
    }

    public int hashCode() {
        return SPRING_DATA_REPOSITORY_CLASS_REF.hashCode();
    }
}

