/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.advice;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosTarget;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.AbstractChaosMonkeyAdvice;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.health.contributor.Health;

public class ChaosMonkeyHealthIndicatorAdvice
extends AbstractChaosMonkeyAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChaosMonkeyHealthIndicatorAdvice.class);
    private final ChaosMonkeyRequestScope chaosMonkeyRequestScope;
    private final WatcherProperties watcherProperties;

    @Override
    public Object invoke(ProceedingJoinPoint pjp) throws Throwable {
        Health health = (Health)pjp.proceed();
        if (this.watcherProperties.isActuatorHealth()) {
            MethodSignature signature = (MethodSignature)pjp.getSignature();
            try {
                this.chaosMonkeyRequestScope.callChaosMonkey(ChaosTarget.ACTUATOR_HEALTH, this.createSignature(signature));
            }
            catch (Exception e) {
                log.error("Exception occurred", (Throwable)e);
                health = Health.down((Throwable)e).build();
            }
        }
        return health;
    }

    @Generated
    public ChaosMonkeyHealthIndicatorAdvice(ChaosMonkeyRequestScope chaosMonkeyRequestScope, WatcherProperties watcherProperties) {
        this.chaosMonkeyRequestScope = chaosMonkeyRequestScope;
        this.watcherProperties = watcherProperties;
    }
}

