/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.endpoints.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChaosMonkeyStatusResponseDto {
    private boolean isEnabled;
    private OffsetDateTime enabledAt;
    private OffsetDateTime disabledAt;
    private Value<Duration> enabledFor;

    public ChaosMonkeyStatusResponseDto(boolean isEnabled, @Nullable Long lastStatusToggleTimestamp, @Nullable Duration enabledFor) {
        this.isEnabled = isEnabled;
        OffsetDateTime lastStatusToggleTime = lastStatusToggleTimestamp != null ? OffsetDateTime.ofInstant(Instant.ofEpochMilli(lastStatusToggleTimestamp), ZoneId.systemDefault()) : null;
        this.enabledAt = isEnabled ? lastStatusToggleTime : null;
        this.disabledAt = !isEnabled ? lastStatusToggleTime : null;
        this.enabledFor = enabledFor != null ? new Value<Duration>(enabledFor, this.formatDuration(enabledFor)) : null;
    }

    private String formatDuration(Duration duration) {
        long inSeconds = duration.getSeconds();
        long secondsPart = inSeconds % 60L;
        long minutesPart = inSeconds % 3600L / 60L;
        if (duration.toHours() > 0L) {
            return String.format("%d hours %02d minutes %02d seconds", duration.toHours(), minutesPart, secondsPart);
        }
        if (duration.toMinutes() > 0L) {
            return String.format("%d minutes %02d seconds", duration.toMinutes(), secondsPart);
        }
        return String.format("%d seconds", inSeconds);
    }

    @Generated
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Generated
    public OffsetDateTime getEnabledAt() {
        return this.enabledAt;
    }

    @Generated
    public OffsetDateTime getDisabledAt() {
        return this.disabledAt;
    }

    @Generated
    public Value<Duration> getEnabledFor() {
        return this.enabledFor;
    }

    @Generated
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Generated
    public void setEnabledAt(OffsetDateTime enabledAt) {
        this.enabledAt = enabledAt;
    }

    @Generated
    public void setDisabledAt(OffsetDateTime disabledAt) {
        this.disabledAt = disabledAt;
    }

    @Generated
    public void setEnabledFor(Value<Duration> enabledFor) {
        this.enabledFor = enabledFor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChaosMonkeyStatusResponseDto)) {
            return false;
        }
        ChaosMonkeyStatusResponseDto other = (ChaosMonkeyStatusResponseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        OffsetDateTime this$enabledAt = this.getEnabledAt();
        OffsetDateTime other$enabledAt = other.getEnabledAt();
        if (this$enabledAt == null ? other$enabledAt != null : !((Object)this$enabledAt).equals(other$enabledAt)) {
            return false;
        }
        OffsetDateTime this$disabledAt = this.getDisabledAt();
        OffsetDateTime other$disabledAt = other.getDisabledAt();
        if (this$disabledAt == null ? other$disabledAt != null : !((Object)this$disabledAt).equals(other$disabledAt)) {
            return false;
        }
        Value<Duration> this$enabledFor = this.getEnabledFor();
        Value<Duration> other$enabledFor = other.getEnabledFor();
        return !(this$enabledFor == null ? other$enabledFor != null : !((Object)this$enabledFor).equals(other$enabledFor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChaosMonkeyStatusResponseDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        OffsetDateTime $enabledAt = this.getEnabledAt();
        result = result * 59 + ($enabledAt == null ? 43 : ((Object)$enabledAt).hashCode());
        OffsetDateTime $disabledAt = this.getDisabledAt();
        result = result * 59 + ($disabledAt == null ? 43 : ((Object)$disabledAt).hashCode());
        Value<Duration> $enabledFor = this.getEnabledFor();
        result = result * 59 + ($enabledFor == null ? 43 : ((Object)$enabledFor).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChaosMonkeyStatusResponseDto(isEnabled=" + this.isEnabled() + ", enabledAt=" + String.valueOf(this.getEnabledAt()) + ", disabledAt=" + String.valueOf(this.getDisabledAt()) + ", enabledFor=" + String.valueOf(this.getEnabledFor()) + ")";
    }

    @Generated
    public ChaosMonkeyStatusResponseDto() {
    }

    public static class Value<T> {
        private T raw;
        private String formatted;

        @Generated
        public T getRaw() {
            return this.raw;
        }

        @Generated
        public String getFormatted() {
            return this.formatted;
        }

        @Generated
        public void setRaw(T raw) {
            this.raw = raw;
        }

        @Generated
        public void setFormatted(String formatted) {
            this.formatted = formatted;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value other = (Value)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$raw = this.getRaw();
            T other$raw = other.getRaw();
            if (this$raw == null ? other$raw != null : !this$raw.equals(other$raw)) {
                return false;
            }
            String this$formatted = this.getFormatted();
            String other$formatted = other.getFormatted();
            return !(this$formatted == null ? other$formatted != null : !this$formatted.equals(other$formatted));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Value;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $raw = this.getRaw();
            result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
            String $formatted = this.getFormatted();
            result = result * 59 + ($formatted == null ? 43 : $formatted.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ChaosMonkeyStatusResponseDto.Value(raw=" + String.valueOf(this.getRaw()) + ", formatted=" + this.getFormatted() + ")";
        }

        @Generated
        public Value() {
        }

        @Generated
        public Value(T raw, String formatted) {
            this.raw = raw;
            this.formatted = formatted;
        }
    }
}

