/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.endpoints;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRuntimeScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyScheduler;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.endpoints.BaseChaosMonkeyEndpoint;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.AssaultPropertiesUpdate;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.ChaosMonkeySettingsDto;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.ChaosMonkeyStatusResponseDto;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.WatcherPropertiesUpdate;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@RestControllerEndpoint(defaultAccess=Access.NONE, id="chaosmonkey")
public class ChaosMonkeyRestEndpoint
extends BaseChaosMonkeyEndpoint {
    private final ChaosMonkeyRuntimeScope runtimeScope;
    private final ChaosMonkeyScheduler scheduler;

    public ChaosMonkeyRestEndpoint(ChaosMonkeySettings chaosMonkeySettings, ChaosMonkeyRuntimeScope runtimeScope, ChaosMonkeyScheduler scheduler) {
        super(chaosMonkeySettings);
        this.runtimeScope = runtimeScope;
        this.scheduler = scheduler;
    }

    @PostMapping(value={"/assaults"})
    @ResponseBody
    public String updateAssaultProperties(@RequestBody @Validated AssaultPropertiesUpdate assaultProperties) {
        assaultProperties.applyTo(this.chaosMonkeySettings.getAssaultProperties());
        this.scheduler.reloadConfig();
        return "Assault config has changed";
    }

    @PostMapping(value={"/assaults/runtime/attack"})
    @ResponseBody
    public String attack() {
        this.runtimeScope.callChaosMonkey();
        return "Started runtime assaults";
    }

    @Override
    @GetMapping(value={"/assaults"})
    public AssaultPropertiesUpdate getAssaultProperties() {
        return super.getAssaultProperties();
    }

    @Override
    @PostMapping(value={"/enable"})
    public ChaosMonkeyStatusResponseDto enableChaosMonkey() {
        return super.enableChaosMonkey();
    }

    @Override
    @PostMapping(value={"/disable"})
    public ChaosMonkeyStatusResponseDto disableChaosMonkey() {
        return super.disableChaosMonkey();
    }

    @GetMapping
    public ChaosMonkeySettingsDto status() {
        return this.chaosMonkeySettings.toDto();
    }

    @Override
    @GetMapping(value={"/status"})
    public ChaosMonkeyStatusResponseDto getStatus() {
        return super.getStatus();
    }

    @PostMapping(value={"/watchers"})
    @ResponseBody
    public String updateWatcherProperties(@RequestBody @Validated WatcherPropertiesUpdate watcherProperties) {
        watcherProperties.applyTo(this.chaosMonkeySettings.getWatcherProperties());
        this.scheduler.reloadConfig();
        return "Watcher config has changed";
    }

    @Override
    @GetMapping(value={"/watchers"})
    public WatcherProperties getWatcherProperties() {
        return super.getWatcherProperties();
    }
}

