/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultException;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.AssaultPropertiesUpdate;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.CollectionUtils;
import tools.jackson.databind.ObjectMapper;

@ConfigurationProperties(prefix="chaos.monkey.assaults")
public class AssaultProperties {
    private int level = 1;
    private boolean deterministic = false;
    private int latencyRangeStart = 1000;
    private int latencyRangeEnd = 3000;
    private boolean latencyActive = false;
    private boolean exceptionsActive = false;
    @NestedConfigurationProperty
    private AssaultException exception;
    private boolean killApplicationActive = false;
    private String killApplicationCronExpression = "OFF";
    private volatile boolean memoryActive = false;
    private int memoryMillisecondsHoldFilledMemory = 90000;
    private int memoryMillisecondsWaitNextIncrease = 1000;
    private double memoryFillIncrementFraction = 0.15;
    private double memoryFillTargetFraction = 0.25;
    private String memoryCronExpression = "OFF";
    private volatile boolean cpuActive = false;
    private int cpuMillisecondsHoldLoad = 90000;
    private double cpuLoadTargetFraction = 0.9;
    private String cpuCronExpression = "OFF";
    private List<String> watchedCustomServices;

    public AssaultException getException() {
        return this.exception == null ? new AssaultException() : this.exception;
    }

    public void setException(AssaultException exception) {
        this.exception = exception;
    }

    @JsonIgnore
    public int getTroubleRandom() {
        return ThreadLocalRandom.current().nextInt(1, this.getLevel() + 1);
    }

    @JsonIgnore
    public int chooseAssault(int amount) {
        return ThreadLocalRandom.current().nextInt(0, amount);
    }

    @JsonIgnore
    public boolean isWatchedCustomServicesActive() {
        return !CollectionUtils.isEmpty(this.watchedCustomServices);
    }

    public AssaultPropertiesUpdate toDto() {
        return (AssaultPropertiesUpdate)new ObjectMapper().convertValue((Object)this, AssaultPropertiesUpdate.class);
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Generated
    public int getLatencyRangeStart() {
        return this.latencyRangeStart;
    }

    @Generated
    public int getLatencyRangeEnd() {
        return this.latencyRangeEnd;
    }

    @Generated
    public boolean isLatencyActive() {
        return this.latencyActive;
    }

    @Generated
    public boolean isExceptionsActive() {
        return this.exceptionsActive;
    }

    @Generated
    public boolean isKillApplicationActive() {
        return this.killApplicationActive;
    }

    @Generated
    public String getKillApplicationCronExpression() {
        return this.killApplicationCronExpression;
    }

    @Generated
    public boolean isMemoryActive() {
        return this.memoryActive;
    }

    @Generated
    public int getMemoryMillisecondsHoldFilledMemory() {
        return this.memoryMillisecondsHoldFilledMemory;
    }

    @Generated
    public int getMemoryMillisecondsWaitNextIncrease() {
        return this.memoryMillisecondsWaitNextIncrease;
    }

    @Generated
    public double getMemoryFillIncrementFraction() {
        return this.memoryFillIncrementFraction;
    }

    @Generated
    public double getMemoryFillTargetFraction() {
        return this.memoryFillTargetFraction;
    }

    @Generated
    public String getMemoryCronExpression() {
        return this.memoryCronExpression;
    }

    @Generated
    public boolean isCpuActive() {
        return this.cpuActive;
    }

    @Generated
    public int getCpuMillisecondsHoldLoad() {
        return this.cpuMillisecondsHoldLoad;
    }

    @Generated
    public double getCpuLoadTargetFraction() {
        return this.cpuLoadTargetFraction;
    }

    @Generated
    public String getCpuCronExpression() {
        return this.cpuCronExpression;
    }

    @Generated
    public List<String> getWatchedCustomServices() {
        return this.watchedCustomServices;
    }

    @Generated
    public void setLevel(int level) {
        this.level = level;
    }

    @Generated
    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    @Generated
    public void setLatencyRangeStart(int latencyRangeStart) {
        this.latencyRangeStart = latencyRangeStart;
    }

    @Generated
    public void setLatencyRangeEnd(int latencyRangeEnd) {
        this.latencyRangeEnd = latencyRangeEnd;
    }

    @Generated
    public void setLatencyActive(boolean latencyActive) {
        this.latencyActive = latencyActive;
    }

    @Generated
    public void setExceptionsActive(boolean exceptionsActive) {
        this.exceptionsActive = exceptionsActive;
    }

    @Generated
    public void setKillApplicationActive(boolean killApplicationActive) {
        this.killApplicationActive = killApplicationActive;
    }

    @Generated
    public void setKillApplicationCronExpression(String killApplicationCronExpression) {
        this.killApplicationCronExpression = killApplicationCronExpression;
    }

    @Generated
    public void setMemoryActive(boolean memoryActive) {
        this.memoryActive = memoryActive;
    }

    @Generated
    public void setMemoryMillisecondsHoldFilledMemory(int memoryMillisecondsHoldFilledMemory) {
        this.memoryMillisecondsHoldFilledMemory = memoryMillisecondsHoldFilledMemory;
    }

    @Generated
    public void setMemoryMillisecondsWaitNextIncrease(int memoryMillisecondsWaitNextIncrease) {
        this.memoryMillisecondsWaitNextIncrease = memoryMillisecondsWaitNextIncrease;
    }

    @Generated
    public void setMemoryFillIncrementFraction(double memoryFillIncrementFraction) {
        this.memoryFillIncrementFraction = memoryFillIncrementFraction;
    }

    @Generated
    public void setMemoryFillTargetFraction(double memoryFillTargetFraction) {
        this.memoryFillTargetFraction = memoryFillTargetFraction;
    }

    @Generated
    public void setMemoryCronExpression(String memoryCronExpression) {
        this.memoryCronExpression = memoryCronExpression;
    }

    @Generated
    public void setCpuActive(boolean cpuActive) {
        this.cpuActive = cpuActive;
    }

    @Generated
    public void setCpuMillisecondsHoldLoad(int cpuMillisecondsHoldLoad) {
        this.cpuMillisecondsHoldLoad = cpuMillisecondsHoldLoad;
    }

    @Generated
    public void setCpuLoadTargetFraction(double cpuLoadTargetFraction) {
        this.cpuLoadTargetFraction = cpuLoadTargetFraction;
    }

    @Generated
    public void setCpuCronExpression(String cpuCronExpression) {
        this.cpuCronExpression = cpuCronExpression;
    }

    @Generated
    public void setWatchedCustomServices(List<String> watchedCustomServices) {
        this.watchedCustomServices = watchedCustomServices;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultProperties)) {
            return false;
        }
        AssaultProperties other = (AssaultProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.isDeterministic() != other.isDeterministic()) {
            return false;
        }
        if (this.getLatencyRangeStart() != other.getLatencyRangeStart()) {
            return false;
        }
        if (this.getLatencyRangeEnd() != other.getLatencyRangeEnd()) {
            return false;
        }
        if (this.isLatencyActive() != other.isLatencyActive()) {
            return false;
        }
        if (this.isExceptionsActive() != other.isExceptionsActive()) {
            return false;
        }
        if (this.isKillApplicationActive() != other.isKillApplicationActive()) {
            return false;
        }
        if (this.isMemoryActive() != other.isMemoryActive()) {
            return false;
        }
        if (this.getMemoryMillisecondsHoldFilledMemory() != other.getMemoryMillisecondsHoldFilledMemory()) {
            return false;
        }
        if (this.getMemoryMillisecondsWaitNextIncrease() != other.getMemoryMillisecondsWaitNextIncrease()) {
            return false;
        }
        if (Double.compare(this.getMemoryFillIncrementFraction(), other.getMemoryFillIncrementFraction()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemoryFillTargetFraction(), other.getMemoryFillTargetFraction()) != 0) {
            return false;
        }
        if (this.isCpuActive() != other.isCpuActive()) {
            return false;
        }
        if (this.getCpuMillisecondsHoldLoad() != other.getCpuMillisecondsHoldLoad()) {
            return false;
        }
        if (Double.compare(this.getCpuLoadTargetFraction(), other.getCpuLoadTargetFraction()) != 0) {
            return false;
        }
        AssaultException this$exception = this.getException();
        AssaultException other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !((Object)this$exception).equals(other$exception)) {
            return false;
        }
        String this$killApplicationCronExpression = this.getKillApplicationCronExpression();
        String other$killApplicationCronExpression = other.getKillApplicationCronExpression();
        if (this$killApplicationCronExpression == null ? other$killApplicationCronExpression != null : !this$killApplicationCronExpression.equals(other$killApplicationCronExpression)) {
            return false;
        }
        String this$memoryCronExpression = this.getMemoryCronExpression();
        String other$memoryCronExpression = other.getMemoryCronExpression();
        if (this$memoryCronExpression == null ? other$memoryCronExpression != null : !this$memoryCronExpression.equals(other$memoryCronExpression)) {
            return false;
        }
        String this$cpuCronExpression = this.getCpuCronExpression();
        String other$cpuCronExpression = other.getCpuCronExpression();
        if (this$cpuCronExpression == null ? other$cpuCronExpression != null : !this$cpuCronExpression.equals(other$cpuCronExpression)) {
            return false;
        }
        List<String> this$watchedCustomServices = this.getWatchedCustomServices();
        List<String> other$watchedCustomServices = other.getWatchedCustomServices();
        return !(this$watchedCustomServices == null ? other$watchedCustomServices != null : !((Object)this$watchedCustomServices).equals(other$watchedCustomServices));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssaultProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        result = result * 59 + (this.isDeterministic() ? 79 : 97);
        result = result * 59 + this.getLatencyRangeStart();
        result = result * 59 + this.getLatencyRangeEnd();
        result = result * 59 + (this.isLatencyActive() ? 79 : 97);
        result = result * 59 + (this.isExceptionsActive() ? 79 : 97);
        result = result * 59 + (this.isKillApplicationActive() ? 79 : 97);
        result = result * 59 + (this.isMemoryActive() ? 79 : 97);
        result = result * 59 + this.getMemoryMillisecondsHoldFilledMemory();
        result = result * 59 + this.getMemoryMillisecondsWaitNextIncrease();
        long $memoryFillIncrementFraction = Double.doubleToLongBits(this.getMemoryFillIncrementFraction());
        result = result * 59 + (int)($memoryFillIncrementFraction >>> 32 ^ $memoryFillIncrementFraction);
        long $memoryFillTargetFraction = Double.doubleToLongBits(this.getMemoryFillTargetFraction());
        result = result * 59 + (int)($memoryFillTargetFraction >>> 32 ^ $memoryFillTargetFraction);
        result = result * 59 + (this.isCpuActive() ? 79 : 97);
        result = result * 59 + this.getCpuMillisecondsHoldLoad();
        long $cpuLoadTargetFraction = Double.doubleToLongBits(this.getCpuLoadTargetFraction());
        result = result * 59 + (int)($cpuLoadTargetFraction >>> 32 ^ $cpuLoadTargetFraction);
        AssaultException $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : ((Object)$exception).hashCode());
        String $killApplicationCronExpression = this.getKillApplicationCronExpression();
        result = result * 59 + ($killApplicationCronExpression == null ? 43 : $killApplicationCronExpression.hashCode());
        String $memoryCronExpression = this.getMemoryCronExpression();
        result = result * 59 + ($memoryCronExpression == null ? 43 : $memoryCronExpression.hashCode());
        String $cpuCronExpression = this.getCpuCronExpression();
        result = result * 59 + ($cpuCronExpression == null ? 43 : $cpuCronExpression.hashCode());
        List<String> $watchedCustomServices = this.getWatchedCustomServices();
        result = result * 59 + ($watchedCustomServices == null ? 43 : ((Object)$watchedCustomServices).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssaultProperties(level=" + this.getLevel() + ", deterministic=" + this.isDeterministic() + ", latencyRangeStart=" + this.getLatencyRangeStart() + ", latencyRangeEnd=" + this.getLatencyRangeEnd() + ", latencyActive=" + this.isLatencyActive() + ", exceptionsActive=" + this.isExceptionsActive() + ", exception=" + String.valueOf(this.getException()) + ", killApplicationActive=" + this.isKillApplicationActive() + ", killApplicationCronExpression=" + this.getKillApplicationCronExpression() + ", memoryActive=" + this.isMemoryActive() + ", memoryMillisecondsHoldFilledMemory=" + this.getMemoryMillisecondsHoldFilledMemory() + ", memoryMillisecondsWaitNextIncrease=" + this.getMemoryMillisecondsWaitNextIncrease() + ", memoryFillIncrementFraction=" + this.getMemoryFillIncrementFraction() + ", memoryFillTargetFraction=" + this.getMemoryFillTargetFraction() + ", memoryCronExpression=" + this.getMemoryCronExpression() + ", cpuActive=" + this.isCpuActive() + ", cpuMillisecondsHoldLoad=" + this.getCpuMillisecondsHoldLoad() + ", cpuLoadTargetFraction=" + this.getCpuLoadTargetFraction() + ", cpuCronExpression=" + this.getCpuCronExpression() + ", watchedCustomServices=" + String.valueOf(this.getWatchedCustomServices()) + ")";
    }

    @Generated
    public AssaultProperties() {
    }
}

