/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.ClassUtils;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.exc.MismatchedInputException;

public class AssaultException {
    private static final Logger Logger = LoggerFactory.getLogger(AssaultException.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String DEFAULT_CONSTRUCTOR_KEYWORD = "<init>";
    private static final String ALTERNATIVE_CONSTRUCTOR_KEYWORD = "[init]";
    private static final List<String> CONSTRUCTOR_KEYWORDS = List.of("<init>", "[init]");
    @NotNull
    private String type = "java.lang.RuntimeException";
    @NotNull
    private String method = "<init>";
    @NotNull
    @NestedConfigurationProperty
    private List<ExceptionArgument> arguments = Collections.singletonList(new ExceptionArgument(String.class.getName(), "Chaos Monkey - RuntimeException"));

    @JsonIgnore
    public void throwExceptionInstance() {
        throw this.getThrowable();
    }

    @JsonIgnore
    private Throwable getThrowable() {
        Throwable instance;
        try {
            ThrowableCreator creator = this.getCreator();
            instance = creator.create(this.getExceptionArgumentValues());
        }
        catch (ClassCastException | ReflectiveOperationException | JacksonException e) {
            Logger.warn("Failed to create custom exception. Fallback: Throw RuntimeException");
            instance = new RuntimeException("Chaos Monkey - RuntimeException (Fallback)", e);
        }
        return instance;
    }

    @JsonIgnore
    public ThrowableCreator getCreator() throws ReflectiveOperationException {
        Class<?> exceptionClass = this.getExceptionClass();
        Class[] argumentTypes = this.getExceptionArgumentTypes().toArray(new Class[0]);
        if (CONSTRUCTOR_KEYWORDS.contains(this.method)) {
            return new ThrowableConstructor(exceptionClass.asSubclass(Throwable.class).getConstructor(argumentTypes));
        }
        return new ThrowableStaticInitializer(exceptionClass.getMethod(this.method, argumentTypes));
    }

    @JsonIgnore
    public Class<?> getExceptionClass() throws ClassNotFoundException {
        return Class.forName(this.type);
    }

    private List<Class<?>> getExceptionArgumentTypes() throws ClassNotFoundException {
        ArrayList exceptionArgumentTypes = new ArrayList();
        for (ExceptionArgument argument : this.arguments) {
            exceptionArgumentTypes.add(argument.getClassType());
        }
        return exceptionArgumentTypes;
    }

    private List<Object> getExceptionArgumentValues() throws ClassNotFoundException {
        ArrayList<Object> exceptionArgumentValues = new ArrayList<Object>();
        for (ExceptionArgument argument : this.arguments) {
            Class<?> classType = argument.getClassType();
            String value = argument.getValue();
            try {
                exceptionArgumentValues.add(objectMapper.convertValue((Object)value, classType));
            }
            catch (IllegalArgumentException | MismatchedInputException e) {
                exceptionArgumentValues.add(objectMapper.readValue(value, classType));
            }
        }
        return exceptionArgumentValues;
    }

    @Generated
    public AssaultException() {
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public List<ExceptionArgument> getArguments() {
        return this.arguments;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setArguments(List<ExceptionArgument> arguments) {
        this.arguments = arguments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultException)) {
            return false;
        }
        AssaultException other = (AssaultException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        List<ExceptionArgument> this$arguments = this.getArguments();
        List<ExceptionArgument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssaultException;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        List<ExceptionArgument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssaultException(type=" + this.getType() + ", method=" + this.getMethod() + ", arguments=" + String.valueOf(this.getArguments()) + ")";
    }

    private static interface ThrowableCreator {
        public Throwable create(List<?> var1) throws ReflectiveOperationException;
    }

    private record ThrowableConstructor(Constructor<? extends Throwable> constructor) implements ThrowableCreator
    {
        @Override
        public Throwable create(List<?> arguments) throws ReflectiveOperationException {
            return this.constructor.newInstance(arguments.toArray());
        }
    }

    private record ThrowableStaticInitializer(Method initializer) implements ThrowableCreator
    {
        @Override
        public Throwable create(List<?> arguments) throws ReflectiveOperationException {
            return (Throwable)this.initializer.invoke(null, arguments.toArray());
        }
    }

    public static class ExceptionArgument {
        @NotNull
        private String type;
        @NotNull
        private String value;

        @JsonIgnore
        public Class<?> getClassType() throws ClassNotFoundException {
            return ClassUtils.forName((String)this.type, null);
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExceptionArgument)) {
                return false;
            }
            ExceptionArgument other = (ExceptionArgument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExceptionArgument;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssaultException.ExceptionArgument(type=" + this.getType() + ", value=" + this.getValue() + ")";
        }

        @Generated
        public ExceptionArgument() {
        }

        @Generated
        public ExceptionArgument(String type, String value) {
            this.type = type;
            this.value = value;
        }
    }
}

