/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.assaults;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRuntimeAssault;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KillAppAssault
implements ChaosMonkeyRuntimeAssault {
    private static final Logger Logger = LoggerFactory.getLogger(KillAppAssault.class);
    private final MetricEventPublisher metricEventPublisher;
    private final ChaosMonkeySettings settings;
    private final ExitHelper exitHelper;

    public KillAppAssault(ChaosMonkeySettings settings, MetricEventPublisher metricEventPublisher) {
        this(settings, metricEventPublisher, new ExitHelper());
    }

    public KillAppAssault(ChaosMonkeySettings settings, MetricEventPublisher metricEventPublisher, ExitHelper exitHelper) {
        this.settings = settings;
        this.metricEventPublisher = metricEventPublisher;
        this.exitHelper = exitHelper;
    }

    @Override
    public boolean isActive() {
        return this.settings.getAssaultProperties().isKillApplicationActive();
    }

    @Override
    public void attack() {
        try {
            Logger.info("Chaos Monkey - I am killing your Application!");
            this.metricEventPublisher.publishMetricEvent(MetricType.KILLAPP_ASSAULT, new String[0]);
            Thread thread = new Thread(this::killApplication);
            thread.setContextClassLoader(this.getClass().getClassLoader());
            thread.start();
        }
        catch (Exception e) {
            Logger.info("Chaos Monkey - Unable to kill the App, I am not the BOSS!");
        }
    }

    private void killApplication() {
        int exitCode = this.exitHelper.exitSpringApplication(0);
        long remaining = 5000L;
        long end = System.currentTimeMillis() + remaining;
        while (true) {
            try {
                TimeUnit.MILLISECONDS.sleep(remaining);
            }
            catch (InterruptedException ignored) {
                remaining = end - System.currentTimeMillis();
                continue;
            }
            break;
        }
        this.exitHelper.exitJvm(exitCode);
    }

    @Override
    public String getCronExpression(AssaultProperties assaultProperties) {
        return assaultProperties.getKillApplicationCronExpression();
    }

    public static class ExitHelper
    implements ApplicationContextAware {
        private ApplicationContext context;

        public int exitSpringApplication(int code) {
            return SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> code});
        }

        public void exitJvm(int code) {
            System.exit(code);
        }

        public void setApplicationContext(@NonNull ApplicationContext context) {
            this.context = context;
        }
    }
}

