/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.assaults;

import com.sun.management.OperatingSystemMXBean;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRuntimeAssault;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuAssault
implements ChaosMonkeyRuntimeAssault {
    private static final double leeway = 0.05;
    private static final Logger Logger = LoggerFactory.getLogger(CpuAssault.class);
    private final ChaosMonkeySettings settings;
    private final MetricEventPublisher metricEventPublisher;
    private final OperatingSystemMXBean os;

    public CpuAssault(OperatingSystemMXBean os, ChaosMonkeySettings settings, MetricEventPublisher metricEventPublisher) {
        this.os = os;
        this.settings = settings;
        this.metricEventPublisher = metricEventPublisher;
    }

    @Override
    public boolean isActive() {
        return this.settings.getAssaultProperties().isCpuActive();
    }

    @Override
    public void attack() {
        Logger.info("Chaos Monkey - cpu assault");
        this.metricEventPublisher.publishMetricEvent(MetricType.CPU_ASSAULT, new String[0]);
        double load = this.settings.getAssaultProperties().getCpuLoadTargetFraction();
        if (this.os.getProcessCpuLoad() >= 0.0) {
            ThreadManager threadManager = new ThreadManager(this.os, load);
            while (this.os.getProcessCpuLoad() < load && this.isActive()) {
                threadManager.tick();
            }
            long targetMs = System.currentTimeMillis() + (long)this.settings.getAssaultProperties().getCpuMillisecondsHoldLoad();
            while (targetMs > System.currentTimeMillis() && this.isActive()) {
                threadManager.tick();
            }
            threadManager.stop();
            Logger.info("Chaos Monkey - cpu assault cleaned up");
        } else {
            Logger.warn("Chaos Monkey - cpu information not available, assault not executed");
        }
    }

    @Override
    public String getCronExpression(AssaultProperties assaultProperties) {
        return assaultProperties.getCpuCronExpression();
    }

    private static class ThreadManager {
        private final OperatingSystemMXBean os;
        private final double targetLoad;
        private final List<WorkerThread> runningThreads = new ArrayList<WorkerThread>();
        private final List<WorkerThread> pausedThreads = new ArrayList<WorkerThread>();
        private double lastLoad;

        private ThreadManager(OperatingSystemMXBean os, double targetLoad) {
            this.os = os;
            this.targetLoad = targetLoad;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tick() {
            double load = this.os.getProcessCpuLoad();
            if (load != this.lastLoad) {
                this.lastLoad = load;
                if (load < this.targetLoad) {
                    WorkerThread thread;
                    if (this.pausedThreads.isEmpty()) {
                        thread = new WorkerThread("CPU Assault thread " + this.runningThreads.size());
                        thread.start();
                    } else {
                        WorkerThread workerThread = thread = this.pausedThreads.remove(0);
                        synchronized (workerThread) {
                            thread.shouldPause = false;
                            thread.notify();
                        }
                    }
                    this.runningThreads.add(thread);
                } else if (load > this.targetLoad + 0.05 && !this.runningThreads.isEmpty()) {
                    WorkerThread thread = this.runningThreads.remove(0);
                    thread.shouldPause = true;
                    this.pausedThreads.add(thread);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void stop() {
            this.runningThreads.addAll(this.pausedThreads);
            for (Thread thread : this.runningThreads) {
                thread.interrupt();
                while (thread.isAlive()) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        thread.interrupt();
                    }
                }
            }
        }
    }

    private static class WorkerThread
    extends Thread {
        private volatile boolean shouldPause = false;

        public WorkerThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long f1 = 0L;
            long f2 = 1L;
            while (!WorkerThread.interrupted()) {
                try {
                    if (this.shouldPause) {
                        WorkerThread workerThread = this;
                        synchronized (workerThread) {
                            this.wait();
                        }
                    }
                    f2 = f1 + f2;
                    f1 = f2 - f1;
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }
    }
}

