/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.aspect;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosTarget;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.watcher.aspect.ChaosMonkeyBaseAspect;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.ReflectiveAspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.SingletonMetadataAwareAspectInstanceFactory;
import org.springframework.aop.framework.AbstractAdvisingBeanPostProcessor;

public class ChaosMonkeyBeanPostProcessor
extends AbstractAdvisingBeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ChaosMonkeyBeanPostProcessor.class);
    private final WatcherProperties watcherProperties;
    private final Map<Object, String> activeBeanNameCache = new WeakHashMap<Object, String>();

    public ChaosMonkeyBeanPostProcessor(WatcherProperties watcherProperties, ChaosMonkeyRequestScope requestScope, MetricEventPublisher eventPublisher) {
        this(watcherProperties, requestScope, eventPublisher, (AspectJAdvisorFactory)new ReflectiveAspectJAdvisorFactory());
    }

    public ChaosMonkeyBeanPostProcessor(WatcherProperties watcherProperties, ChaosMonkeyRequestScope requestScope, MetricEventPublisher eventPublisher, AspectJAdvisorFactory advisorFactory) {
        this.watcherProperties = watcherProperties;
        SpringBeanAspect aspect = new SpringBeanAspect(requestScope, eventPublisher);
        this.advisor = this.convertAspectToAdvisor(advisorFactory, aspect, "springBeanAspect");
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (this.watcherProperties.getBeans().contains(beanName)) {
            Object proxy = super.postProcessAfterInitialization(bean, beanName);
            this.activeBeanNameCache.put(proxy, beanName);
            return proxy;
        }
        return bean;
    }

    private Advisor convertAspectToAdvisor(AspectJAdvisorFactory advisorFactory, Object aspect, String name) {
        SingletonMetadataAwareAspectInstanceFactory factory = new SingletonMetadataAwareAspectInstanceFactory(aspect, name);
        List classAdvisors = advisorFactory.getAdvisors((MetadataAwareAspectInstanceFactory)factory);
        if (classAdvisors.size() != 1) {
            throw new IllegalArgumentException(name + " must contain exactly one advisor");
        }
        return (Advisor)classAdvisors.get(0);
    }

    @Aspect
    public class SpringBeanAspect
    extends ChaosMonkeyBaseAspect {
        private final ChaosMonkeyRequestScope chaosMonkeyRequestScope;
        private MetricEventPublisher metricEventPublisher;

        @Around(value="allPublicMethodPointcut()")
        public Object intercept(ProceedingJoinPoint pjp) throws Throwable {
            if (ChaosMonkeyBeanPostProcessor.this.watcherProperties.getBeans().contains(ChaosMonkeyBeanPostProcessor.this.activeBeanNameCache.get(pjp.getThis()))) {
                log.debug("Watching public method on bean class: {}", (Object)pjp.getSignature());
                if (this.metricEventPublisher != null) {
                    this.metricEventPublisher.publishMetricEvent(this.calculatePointcut(pjp.toShortString()), MetricType.BEAN, new String[0]);
                }
                MethodSignature signature = (MethodSignature)pjp.getSignature();
                this.chaosMonkeyRequestScope.callChaosMonkey(ChaosTarget.BEAN, this.createSignature(signature));
            }
            return pjp.proceed();
        }

        public SpringBeanAspect(ChaosMonkeyRequestScope chaosMonkeyRequestScope, MetricEventPublisher metricEventPublisher) {
            this.chaosMonkeyRequestScope = chaosMonkeyRequestScope;
            this.metricEventPublisher = metricEventPublisher;
        }
    }
}

