/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkey;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.watcher.ChaosMonkeyBaseAspect;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class SpringControllerAspect
extends ChaosMonkeyBaseAspect {
    private final ChaosMonkey chaosMonkey;
    private MetricEventPublisher metricEventPublisher;

    public SpringControllerAspect(ChaosMonkey chaosMonkey, MetricEventPublisher metricEventPublisher) {
        this.chaosMonkey = chaosMonkey;
        this.metricEventPublisher = metricEventPublisher;
    }

    @Pointcut(value="within(@org.springframework.stereotype.Controller *)")
    public void classAnnotatedWithControllerPointcut() {
    }

    @Around(value="classAnnotatedWithControllerPointcut() && allPublicMethodPointcut() && !classInChaosMonkeyPackage()")
    public Object intercept(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.publishMetricEvent(this.calculatePointcut(pjp.toShortString()), MetricType.CONTROLLER, new String[0]);
        }
        this.chaosMonkey.callChaosMonkey(this.createSignature(signature));
        return pjp.proceed();
    }
}

