/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.assaults;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyAssault;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyAssault
implements ChaosMonkeyAssault {
    private static final Logger LOGGER = LoggerFactory.getLogger(LatencyAssault.class);
    private final ChaosMonkeySettings settings;
    private MetricEventPublisher metricEventPublisher;
    private AtomicInteger atomicTimeoutGauge;

    public LatencyAssault(ChaosMonkeySettings settings, MetricEventPublisher metricEventPublisher) {
        this.settings = settings;
        this.metricEventPublisher = metricEventPublisher;
        this.atomicTimeoutGauge = new AtomicInteger(0);
    }

    @Override
    public boolean isActive() {
        return this.settings.getAssaultProperties().isLatencyActive();
    }

    @Override
    public void attack() {
        LOGGER.debug("Chaos Monkey - timeout");
        int timeout = ThreadLocalRandom.current().nextInt(this.settings.getAssaultProperties().getLatencyRangeStart(), this.settings.getAssaultProperties().getLatencyRangeEnd());
        this.atomicTimeoutGauge.set(timeout);
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.publishMetricEvent(MetricType.LATENCY_ASSAULT, new String[0]);
            this.metricEventPublisher.publishMetricEvent(MetricType.LATENCY_ASSAULT, this.atomicTimeoutGauge);
        }
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

