/*
 * Decompiled with CFR 0.152.
 */
package de.codeboje.requestlogging;

import de.codeboje.requestlogging.RequestContextLoggingFilter;
import de.codeboje.requestlogging.Util;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RequestContextLoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestContextLoggingFilter.class);
    private String requestHeaderId = "X-REQUEST-ID";
    private String logIdentifier = "requestId";

    public RequestContextLoggingInterceptor(String requestHeaderId, String logIdentifier) {
        if (StringUtils.isNotEmpty((CharSequence)requestHeaderId)) {
            this.requestHeaderId = requestHeaderId;
        }
        if (StringUtils.isNotEmpty((CharSequence)logIdentifier)) {
            this.logIdentifier = logIdentifier;
        }
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execute) throws IOException {
        String requestUUID = MDC.get((String)this.logIdentifier);
        if (StringUtils.isEmpty((CharSequence)requestUUID)) {
            requestUUID = Util.createId();
            LOGGER.info("Performing Request {} without {} in MDC and assign new {}", new Object[]{request.getURI(), this.logIdentifier, requestUUID});
        }
        request.getHeaders().add(this.requestHeaderId, requestUUID);
        return execute.execute(request, body);
    }
}

