/*
 * Decompiled with CFR 0.152.
 */
package de.codeboje.requestlogging.autoconfigure;

import de.codeboje.requestlogging.RequestContextLoggingFilter;
import de.codeboje.requestlogging.RequestContextLoggingInterceptor;
import de.codeboje.requestlogging.autoconfigure.RequestLoggingProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={RequestContextLoggingFilter.class})
@EnableConfigurationProperties(value={RequestLoggingProperties.class})
public class RequestLoggingAutoConfiguration {
    @Autowired
    private RequestLoggingProperties requestLoggingProperties;

    @Bean
    @Order(value=1)
    @ConditionalOnMissingBean
    public RequestContextLoggingFilter requestContextLoggingFilter() {
        return new RequestContextLoggingFilter(this.requestLoggingProperties.getRequestHeaderId(), this.requestLoggingProperties.getLogIdentifier());
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestContextLoggingInterceptor requestContextLoggingInterceptor() {
        return new RequestContextLoggingInterceptor(this.requestLoggingProperties.getRequestHeaderId(), this.requestLoggingProperties.getLogIdentifier());
    }

    @Bean
    public BeanPostProcessor beanPostProcessor(final RequestContextLoggingInterceptor requestContextLoggingInterceptor) {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof RestTemplate) {
                    ((RestTemplate)bean).getInterceptors().add(0, requestContextLoggingInterceptor);
                }
                return bean;
            }
        };
    }
}

