/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;

public final class JsonTransformer {
    static final Logger LOG = Logger.getLogger((String)JsonTransformer.class.getName());
    private static final ObjectMapper MAPPER = JsonTransformer.getObjectMapper(true);

    public static ObjectMapper getObjectMapper() {
        return JsonTransformer.getObjectMapper(false);
    }

    public static ObjectMapper getObjectMapper(boolean newMapper) {
        if (newMapper) {
            return new ObjectMapper();
        }
        return MAPPER;
    }

    public static <T> String toJson(List<T> list) throws JsonGenerationException, JsonMappingException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((OutputStream)out, list);
        byte[] bytes = out.toByteArray();
        out.close();
        return new String(bytes);
    }

    public static <T> String toJson(T object) throws JsonProcessingException {
        return JsonTransformer.toJson(object, false);
    }

    public static <T> String toJson(T object, boolean newMapper) throws JsonProcessingException {
        ObjectMapper mapper = JsonTransformer.getObjectMapper(newMapper);
        String json = mapper.writeValueAsString(object);
        return json;
    }

    public static <T> String toJsonQuietly(T object) {
        try {
            return JsonTransformer.toJson(object);
        }
        catch (JsonProcessingException e) {
            LOG.error((Object)("An error occured when converting object to String.\nGiven object:" + object.toString() + "\n"), (Throwable)e);
            return null;
        }
    }

    public static <T> T toObject(String jsonString, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return JsonTransformer.toObject(jsonString, clazz, false);
    }

    public static <T> T toObject(String jsonString, Class<T> clazz, boolean newMapper) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = JsonTransformer.getObjectMapper(newMapper);
        Object object = mapper.readValue(jsonString, clazz);
        return (T)object;
    }

    public static <T> T toObject(String jsonString, Class<T> clazz, Module ... modules) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = JsonTransformer.getObjectMapper(true);
        mapper = mapper.registerModules(modules);
        Object object = mapper.readValue(jsonString, clazz);
        return (T)object;
    }

    public static <T> List<T> toObjectList(String jsonString, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = JsonTransformer.getObjectMapper(true);
        List objectList = (List)mapper.readValue(jsonString, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, clazz));
        return objectList;
    }

    private JsonTransformer() {
    }
}

