/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.tag;

import de.alpharogroup.clone.object.CloneObjectQuietlyExtensions;
import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.map.MapFactory;
import de.alpharogroup.xml.tag.ChildTagPosition;
import de.alpharogroup.xml.tag.TagExtensions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Tag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> attributes;
    private List<ChildTagPosition> childTagPositions;
    private String content;
    private boolean endTag;
    private String name;

    public String addAttribute(String name, String value) {
        if (this.getAttributes() == null) {
            this.attributes = MapFactory.newLinkedHashMap();
        }
        return this.getAttributes().put(name, value);
    }

    public boolean addChild(Tag child, Integer position) {
        if (this.getChildren() == null) {
            this.childTagPositions = ListFactory.newArrayList((Object[])new ChildTagPosition[0]);
        }
        ChildTagPosition childTagPosition = ChildTagPosition.builder().child(child).position(position).build();
        return this.getChildren().add(childTagPosition);
    }

    public Object clone() {
        return CloneObjectQuietlyExtensions.cloneQuietly((Object)this);
    }

    public List<ChildTagPosition> getChildren() {
        return this.childTagPositions;
    }

    public String removeAttribute(String name) {
        if (this.getAttributes() != null) {
            this.getAttributes().remove(name);
        }
        return null;
    }

    public boolean removeChild(Tag child) {
        if (this.getChildren() != null) {
            ChildTagPosition found = null;
            for (ChildTagPosition childTagPosition : this.getChildren()) {
                if (!childTagPosition.getChild().equals(child)) continue;
                found = childTagPosition;
                break;
            }
            if (found != null) {
                return this.getChildren().remove(found);
            }
        }
        return false;
    }

    public String toXmlString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        buffer.append(this.getName());
        Optional<String> attr = TagExtensions.attributesToString(this.getAttributes());
        if (attr.isPresent()) {
            buffer.append(attr.get());
        }
        if (this.isEndTag()) {
            buffer.append(">");
            if (this.getChildren() != null && !this.getChildren().isEmpty()) {
                String processingContent = this.getContent();
                Integer lastPosition = 0;
                for (ChildTagPosition child : this.getChildren()) {
                    String subContent = this.getContent().substring(lastPosition, child.getPosition());
                    lastPosition = child.getPosition();
                    processingContent = processingContent.substring(lastPosition, processingContent.length());
                    buffer.append(subContent);
                    buffer.append(child.getChild().toXmlString());
                }
                buffer.append(processingContent);
            } else {
                buffer.append(this.getContent());
            }
            buffer.append("</");
            buffer.append(this.getName());
            buffer.append(">");
        } else {
            buffer.append("/>");
        }
        return buffer.toString();
    }

    public static TagBuilder builder() {
        return new TagBuilder();
    }

    public TagBuilder toBuilder() {
        return new TagBuilder().attributes(this.attributes).childTagPositions(this.childTagPositions).content(this.content).endTag(this.endTag).name(this.name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<ChildTagPosition> getChildTagPositions() {
        return this.childTagPositions;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isEndTag() {
        return this.endTag;
    }

    public String getName() {
        return this.name;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setChildTagPositions(List<ChildTagPosition> childTagPositions) {
        this.childTagPositions = childTagPositions;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setEndTag(boolean endTag) {
        this.endTag = endTag;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Tag(content=" + this.getContent() + ", endTag=" + this.isEndTag() + ", name=" + this.getName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        if (this.isEndTag() != other.isEndTag()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        result = result * 59 + (this.isEndTag() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public Tag() {
    }

    public Tag(Map<String, String> attributes, List<ChildTagPosition> childTagPositions, String content, boolean endTag, String name) {
        this.attributes = attributes;
        this.childTagPositions = childTagPositions;
        this.content = content;
        this.endTag = endTag;
        this.name = name;
    }

    public static class TagBuilder {
        private Map<String, String> attributes;
        private List<ChildTagPosition> childTagPositions;
        private String content;
        private boolean endTag;
        private String name;

        TagBuilder() {
        }

        public TagBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public TagBuilder childTagPositions(List<ChildTagPosition> childTagPositions) {
            this.childTagPositions = childTagPositions;
            return this;
        }

        public TagBuilder content(String content) {
            this.content = content;
            return this;
        }

        public TagBuilder endTag(boolean endTag) {
            this.endTag = endTag;
            return this;
        }

        public TagBuilder name(String name) {
            this.name = name;
            return this;
        }

        public Tag build() {
            return new Tag(this.attributes, this.childTagPositions, this.content, this.endTag, this.name);
        }

        public String toString() {
            return "Tag.TagBuilder(attributes=" + this.attributes + ", childTagPositions=" + this.childTagPositions + ", content=" + this.content + ", endTag=" + this.endTag + ", name=" + this.name + ")";
        }
    }
}

