/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.properties;

import de.alpharogroup.file.copy.CopyFileExtensions;
import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.file.search.FileSearchExtensions;
import de.alpharogroup.resourcebundle.properties.PropertiesExtensions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertiesFileExtensions {
    public static Map<File, Map<String, List<String>>> getRedundantKeys(File dirToSearch) throws IOException {
        List foundFiles = FileSearchExtensions.findAllFiles((File)dirToSearch, (String)FileSearchExtensions.getSearchFilePattern((String[])new String[]{"properties"}));
        LinkedHashMap linesMap = new LinkedHashMap();
        LinkedHashMap<File, Map<String, List<String>>> fileMap = new LinkedHashMap<File, Map<String, List<String>>>();
        for (File file : foundFiles) {
            List<String> lines = PropertiesFileExtensions.removeComments(file);
            Properties p = PropertiesExtensions.loadProperties(file);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = ((String)entry.getKey()).trim();
                for (String line : lines) {
                    char nextChar;
                    if (!line.startsWith(key) || (nextChar = line.charAt(key.length())) == '.') continue;
                    if (nextChar == '=' || nextChar == ':' || nextChar == ' ') {
                        List<String> dl;
                        if (!linesMap.containsKey(key)) {
                            dl = new ArrayList<String>();
                            dl.add(line);
                            linesMap.put(key, dl);
                            continue;
                        }
                        dl = (List)linesMap.get(key);
                        dl.add(line);
                        linesMap.put(key, dl);
                        continue;
                    }
                    throw new RuntimeException("nextChar is '" + nextChar + "'");
                }
            }
            LinkedHashMap duplicateKeys = new LinkedHashMap();
            for (Map.Entry entry : linesMap.entrySet()) {
                if (1 >= ((List)entry.getValue()).size()) continue;
                duplicateKeys.put(entry.getKey(), entry.getValue());
            }
            if (0 >= duplicateKeys.size()) continue;
            fileMap.put(file, duplicateKeys);
        }
        return fileMap;
    }

    public static File newBackupOf(File file) throws IOException {
        return CopyFileExtensions.newBackupOf((File)file, (Charset)Charset.forName("ISO-8859-1"), (Charset)Charset.forName("UTF-8"));
    }

    public static List<String> removeComments(File propertiesFile) throws IOException {
        if (propertiesFile != null && !propertiesFile.getName().matches(FileSearchExtensions.getSearchFilePattern((String[])new String[]{"properties"}))) {
            throw new IllegalArgumentException("The given file is not an properties file.");
        }
        List lines = ReadFileExtensions.readLinesInList((File)propertiesFile);
        Iterator itr = lines.iterator();
        while (itr.hasNext()) {
            String line = (String)itr.next();
            if (!line.startsWith("#") && line.trim().length() != 0) continue;
            itr.remove();
        }
        return lines;
    }
}

