/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.resourcebundle.properties;

import de.alpharogroup.file.FileExtension;
import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.lang.PackageExtensions;
import de.alpharogroup.resourcebundle.file.namefilter.PropertiesResourceBundleFilenameFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public final class PropertiesExtensions {
    public static final String SEARCH_FILE_PATTERN = "([^\\s]+(\\.(?i)(java|html|htm))$)";
    public static final String[] PROPERTIES_DELIMITERS = new String[]{"=", ":", " "};
    private static final Logger LOGGER = Logger.getLogger((String)PropertiesExtensions.class.getName());

    public static Map<String, List<String>> findRedundantValues(Properties properties) {
        List keys;
        LinkedHashMap reverseEntries = new LinkedHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!reverseEntries.containsKey(value)) {
                keys = new ArrayList<String>();
                keys.add(key);
                reverseEntries.put(value, keys);
                continue;
            }
            keys = (List)reverseEntries.get(value);
            keys.add(key);
        }
        LinkedHashMap<String, List<String>> redundantValues = new LinkedHashMap<String, List<String>>();
        for (Map.Entry entry : reverseEntries.entrySet()) {
            String key = (String)entry.getKey();
            keys = (List)entry.getValue();
            if (1 >= keys.size()) continue;
            redundantValues.put(key, keys);
        }
        return redundantValues;
    }

    public static Properties getLocalPropertiesFromClass(Class<?> componentClass, Class<?> defaultClass, Locale locale) throws Exception {
        Properties properties = null;
        properties = componentClass != null ? PropertiesExtensions.loadPropertiesFromClassObject(componentClass, locale) : PropertiesExtensions.loadPropertiesFromClassObject(defaultClass, locale);
        return properties;
    }

    public static Map<String, List<String>> getMatchedPrefixLists(Properties enProperties) {
        Enumeration<?> e = enProperties.propertyNames();
        LinkedHashMap<String, List<String>> matchedPrefixes = new LinkedHashMap<String, List<String>>();
        while (e.hasMoreElements()) {
            List<String> fullKeys;
            String key = (String)e.nextElement();
            int lastIndex = key.lastIndexOf(".");
            String subKey = null;
            subKey = 0 < lastIndex ? key.substring(0, lastIndex) : key;
            if (matchedPrefixes.containsKey(subKey)) {
                fullKeys = (List)matchedPrefixes.get(subKey);
                fullKeys.add(key);
                continue;
            }
            fullKeys = new ArrayList();
            fullKeys.add(key);
            matchedPrefixes.put(subKey, fullKeys);
        }
        return matchedPrefixes;
    }

    public static List<String> getPropertyParameters(String propertyValue) {
        ArrayList<String> parameterList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{.*?\\}");
        Matcher matcher = pattern.matcher(propertyValue);
        while (matcher.find()) {
            String parameter = matcher.group();
            String at = parameter.substring(1, parameter.length() - 1);
            parameterList.add(at);
        }
        return parameterList;
    }

    public static Properties loadProperties(Class<?> clazz, String name) throws IOException {
        InputStream is;
        Properties properties = PropertiesExtensions.loadProperties(name);
        if (properties == null && (is = ClassExtensions.getResourceAsStream(clazz.getClass(), (String)name)) != null) {
            properties = new Properties();
            properties.load(is);
        }
        return properties;
    }

    public static <T> Properties loadProperties(T object, String propertiesFilename) {
        Properties properties = null;
        String packagePath = PackageExtensions.getPackagePathWithSlash(object);
        String propertiespath = packagePath + propertiesFilename;
        try {
            properties = PropertiesExtensions.loadProperties(object.getClass(), propertiespath);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Loading properties file '" + propertiespath + "' with method 'PropertiesExtensions.loadProperties(object.getClass(), propertiespath)' failed."), (Throwable)e);
        }
        if (properties == null) {
            try {
                properties = PropertiesExtensions.getLocalPropertiesFromClass(object.getClass(), object.getClass(), null);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Loading properties file '" + propertiespath + "' with method 'PropertiesExtensions.getLocalPropertiesFromClass(object.getClass(), object.getClass(), null)' failed."), (Throwable)e);
            }
        }
        return properties;
    }

    public static Properties loadProperties(Class<?> clazz, String packagePath, String fileName) throws IOException {
        return PropertiesExtensions.loadProperties(clazz, packagePath + fileName);
    }

    public static Properties loadProperties(File propertiesFile) throws IOException {
        Properties properties = null;
        InputStream is = null;
        if (propertiesFile.exists()) {
            is = propertiesFile.toURI().toURL().openStream();
            if (is != null) {
                properties = new Properties();
                properties.load(is);
            }
        } else {
            throw new FileNotFoundException(propertiesFile.getName() + " not found.");
        }
        return properties;
    }

    public static Properties loadProperties(String packagePath) throws IOException {
        Properties properties = null;
        URL url = ClassExtensions.getResource((String)packagePath);
        if (url != null) {
            properties = new Properties();
            properties.load(url.openStream());
        } else {
            InputStream is = ClassExtensions.getResourceAsStream((String)packagePath);
            if (is != null) {
                properties = new Properties();
                properties.load(is);
            }
        }
        return properties;
    }

    public static Properties loadProperties(String packagePath, String fileName) throws IOException {
        StringBuilder sb = new StringBuilder();
        packagePath = FilenameUtils.normalize((String)packagePath);
        String slash = "/";
        if (packagePath.startsWith("/")) {
            if (packagePath.endsWith("/")) {
                sb.append(packagePath.substring(1, packagePath.length()));
            } else {
                sb.append(packagePath.substring(1, packagePath.length())).append("/");
            }
        } else if (packagePath.endsWith("/")) {
            sb.append(packagePath);
        } else {
            sb.append(packagePath).append("/");
        }
        packagePath = sb.toString().trim();
        sb = new StringBuilder();
        if (fileName.startsWith("/")) {
            sb.append(fileName.substring(1, fileName.length()));
        }
        fileName = sb.toString().trim();
        return PropertiesExtensions.loadProperties(packagePath + fileName);
    }

    public static Properties loadPropertiesFromClassObject(Class<?> clazz, Locale locale) throws IOException {
        if (null == clazz) {
            throw new IllegalArgumentException("Class object must not be null!!!");
        }
        StringBuilder propertiesName = new StringBuilder();
        Properties properties = null;
        String language = null;
        String filename = null;
        String pathAndFilename = null;
        File propertiesFile = null;
        String absoluteFilename = null;
        String packagePath = PackageExtensions.getPackagePathWithSlash(clazz);
        ArrayList<String> missedFiles = new ArrayList<String>();
        if (null != locale) {
            String country;
            propertiesName.append(clazz.getSimpleName());
            language = locale.getLanguage();
            if (null != language && !language.isEmpty()) {
                propertiesName.append("_").append(language);
            }
            if (null != (country = locale.getCountry()) && !country.isEmpty()) {
                propertiesName.append("_").append(country);
            }
            propertiesName.append(FileExtension.PROPERTIES.getExtension());
            filename = propertiesName.toString().trim();
            pathAndFilename = packagePath + filename;
            URL url = ClassExtensions.getResource(clazz, (String)filename);
            if (url != null) {
                absoluteFilename = url.getFile();
            } else {
                missedFiles.add("File with filename '" + filename + "' does not exists.");
            }
            if (null != absoluteFilename) {
                propertiesFile = new File(absoluteFilename);
            }
            if (null != propertiesFile && propertiesFile.exists()) {
                properties = PropertiesExtensions.loadProperties(pathAndFilename);
            } else {
                propertiesName = new StringBuilder();
                if (null != locale) {
                    propertiesName.append(clazz.getSimpleName());
                    language = locale.getLanguage();
                    if (null != language && !language.isEmpty()) {
                        propertiesName.append("_").append(language);
                    }
                    propertiesName.append(FileExtension.PROPERTIES.getExtension());
                    filename = propertiesName.toString().trim();
                    pathAndFilename = packagePath + filename;
                    url = ClassExtensions.getResource(clazz, (String)filename);
                    if (url != null) {
                        absoluteFilename = url.getFile();
                    } else {
                        missedFiles.add("File with filename '" + filename + "' does not exists.");
                    }
                    if (null != absoluteFilename) {
                        propertiesFile = new File(absoluteFilename);
                    }
                    if (null != propertiesFile && propertiesFile.exists()) {
                        properties = PropertiesExtensions.loadProperties(pathAndFilename);
                    }
                }
            }
        }
        if (null == properties) {
            propertiesName = new StringBuilder();
            propertiesName.append(clazz.getSimpleName()).append(FileExtension.PROPERTIES.getExtension());
            filename = propertiesName.toString().trim();
            pathAndFilename = packagePath + filename;
            URL url = ClassExtensions.getResource(clazz, (String)filename);
            if (url != null) {
                absoluteFilename = url.getFile();
            } else {
                properties = PropertiesExtensions.loadProperties(pathAndFilename);
                missedFiles.add("File with filename '" + filename + "' does not exists.");
            }
            if (null != absoluteFilename) {
                propertiesFile = new File(absoluteFilename);
            }
            if (null != propertiesFile && propertiesFile.exists()) {
                properties = PropertiesExtensions.loadProperties(pathAndFilename);
            }
        }
        if (properties == null) {
            for (String string : missedFiles) {
                LOGGER.info((Object)string);
            }
        }
        return properties;
    }

    public static Set<String> resolveAvailableLanguages(String bundlepackage, String bundlename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        File root = new File(loader.getResource(bundlepackage.replace('.', '/')).getFile());
        File[] files = root.listFiles(new PropertiesResourceBundleFilenameFilter(bundlename));
        TreeSet<String> languages = new TreeSet<String>();
        for (File file : files) {
            String language = file.getName().replaceAll("^" + bundlename + "(_)?|\\.properties$", "");
            if (language == null || language.isEmpty()) continue;
            languages.add(language);
        }
        return languages;
    }

    public static void toProperties(File properties, File xml, String comment) throws FileNotFoundException, IOException {
        PropertiesExtensions.toProperties(new FileOutputStream(properties), new FileInputStream(xml), comment);
    }

    public static void toProperties(OutputStream properties, InputStream xml, String comment) throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        prop.loadFromXML(xml);
        prop.store(properties, comment);
    }

    public static void toXml(File properties, File xml, String comment, String encoding) throws FileNotFoundException, IOException {
        PropertiesExtensions.toXml(new FileInputStream(properties), new FileOutputStream(xml), comment, encoding);
    }

    public static void toXml(InputStream properties, OutputStream xml, String comment, String encoding) throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        prop.load(properties);
        prop.storeToXML(xml, comment, encoding);
    }

    private PropertiesExtensions() {
    }
}

