/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.diff.object;

import de.alpharogroup.check.Check;
import de.alpharogroup.compare.object.CompareObjectExtensions;
import de.alpharogroup.diff.beans.ChangedAttributeResult;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public final class DiffObjectExtensions {
    public static Map<Object, ChangedAttributeResult> getChangedDataMap(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Check.get().notNull(sourceOjbect, "sourceOjbect").notNull(objectToCompare, "objectToCompare");
        if (!sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Given sourceObject should be the same type as objectToCompare.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        HashMap<Object, ChangedAttributeResult> changedData = new HashMap<Object, ChangedAttributeResult>();
        for (Object key : beanDescription.keySet()) {
            Object sourceAttribute = beanDescription.get(key);
            Object changedAttribute = clonedBeanDescription.get(key);
            if (CompareObjectExtensions.compareTo((Object)sourceOjbect, (Object)objectToCompare, (String)key.toString()) == 0) continue;
            ChangedAttributeResult result = new ChangedAttributeResult();
            result.setAttributeName(key);
            result.setSourceAttribute(sourceAttribute);
            result.setChangedAttribute(changedAttribute);
            changedData.put(key, result);
        }
        return changedData;
    }

    public static List<ChangedAttributeResult> getChangedData(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Check.get().notNull(sourceOjbect, "sourceOjbect").notNull(objectToCompare, "objectToCompare");
        if (!sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Given sourceObject should be the same type as objectToCompare.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        ArrayList<ChangedAttributeResult> changedData = new ArrayList<ChangedAttributeResult>();
        for (Object key : beanDescription.keySet()) {
            if (CompareObjectExtensions.compareTo((Object)sourceOjbect, (Object)objectToCompare, (String)key.toString()) == 0) continue;
            Object sourceAttribute = beanDescription.get(key);
            Object changedAttribute = clonedBeanDescription.get(key);
            changedData.add(ChangedAttributeResult.builder().attributeName(key).sourceAttribute(sourceAttribute).changedAttribute(changedAttribute).build());
        }
        return changedData;
    }

    public static List<ChangedAttributeResult> getChangedDataWithReflection(Object sourceOjbect, Object objectToCompare, List<ChangedAttributeResult> changedData, ChangedAttributeResult parent) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        if (changedData == null) {
            changedData = new ArrayList<ChangedAttributeResult>();
        }
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            return changedData;
        }
        for (Field field : fields = sourceOjbect.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            Object sourceFieldValue = field.get(sourceOjbect);
            Object toCompareFieldValue = field.get(objectToCompare);
            if (!(sourceFieldValue == null && toCompareFieldValue != null || toCompareFieldValue == null && sourceFieldValue != null) && (sourceFieldValue == null || sourceFieldValue.equals(toCompareFieldValue))) continue;
            ChangedAttributeResult changedAttribute = ChangedAttributeResult.builder().parent(parent).attributeName(field.getName()).sourceAttribute(sourceFieldValue).changedAttribute(toCompareFieldValue).build();
            changedData.add(changedAttribute);
            DiffObjectExtensions.getChangedDataWithReflection(sourceFieldValue, toCompareFieldValue, changedData, changedAttribute);
        }
        return changedData;
    }

    private DiffObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

