/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.slider;

import de.agilecoders.wicket.extensions.slider.BootstrapDoubleSliderConverter;
import de.agilecoders.wicket.extensions.slider.BootstrapIntegerSliderConverter;
import de.agilecoders.wicket.extensions.slider.BootstrapLongSliderConverter;
import de.agilecoders.wicket.extensions.slider.ISliderValue;
import de.agilecoders.wicket.extensions.slider.res.BootstrapSliderCssResourceReference;
import de.agilecoders.wicket.extensions.slider.res.BootstrapSliderResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.convert.IConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapSlider<T extends ISliderValue, N extends Number>
extends TextField<T> {
    private static Logger logger = LoggerFactory.getLogger(BootstrapSlider.class);
    private final IConverter<ISliderValue> converter;
    private N min;
    private N max;
    private N step;
    private TooltipType tooltip;
    private HandleType handle;
    private String formatter;
    private Orientation orientation;
    private Boolean reversed;
    private Boolean tooltipSplit;
    private Integer precision;
    private Scale scale;

    public BootstrapSlider(String id, IModel<T> model, Class<T> typeClass) {
        super(id, model, typeClass);
        this.setOutputMarkupId(true);
        try {
            this.converter = Double.class.isAssignableFrom(((ISliderValue)typeClass.newInstance()).getNumberType()) ? new BootstrapDoubleSliderConverter() : (Integer.class.isAssignableFrom(((ISliderValue)typeClass.newInstance()).getNumberType()) ? new BootstrapIntegerSliderConverter() : new BootstrapLongSliderConverter());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    protected T newInstance() {
        try {
            return (T)((ISliderValue)this.getType().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("An error occurred while instantiating ISliderValue", (Throwable)e);
            return null;
        }
    }

    public String getInput() {
        String input = super.getInput();
        if (input != null && input.indexOf(44) > 0) {
            return "[" + input + "]";
        }
        return input;
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (ISliderValue.class.isAssignableFrom(type)) {
            return this.converter;
        }
        return super.getConverter(type);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        tag.put("data-slider-value", (CharSequence)this.converter.convertToString(this.getModelObject(), this.getLocale()));
        tag.put("data-slider-min", (CharSequence)(this.min != null ? this.min.toString() : "0"));
        tag.put("data-slider-max", (CharSequence)(this.max != null ? this.max.toString() : "10"));
        tag.put("data-slider-step", (CharSequence)(this.step != null ? this.step.toString() : "1"));
        tag.put("type", (CharSequence)"text");
        if (this.tooltip != null) {
            tag.put("data-slider-tooltip", (CharSequence)this.tooltip.name());
        }
        if (this.handle != null) {
            tag.put("data-slider-handle", (CharSequence)this.handle.name());
        }
        if (!this.isEnabled()) {
            tag.put("data-slider-enabled", false);
        }
        if (this.orientation != null) {
            tag.put("data-slider-orientation", (CharSequence)this.orientation.name());
        }
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapSliderResourceReference.getInstance()));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)BootstrapSliderCssResourceReference.getInstance()));
        StringBuilder builder = new StringBuilder();
        builder.append("$('#").append(this.getMarkupId()).append("').slider({");
        if (this.formatter != null) {
            builder.append("'formatter':").append(this.formatter);
        }
        if (this.reversed != null && this.reversed.equals(true)) {
            builder.append("'reversed':").append(this.reversed);
        }
        if (this.tooltipSplit != null && this.tooltipSplit.equals(true)) {
            builder.append("'tooltip_split':").append(this.tooltipSplit);
        }
        if (this.precision != null) {
            builder.append("'precision':").append(this.precision);
        }
        if (this.scale != null) {
            builder.append("'scale':").append((Object)this.scale);
        }
        this.configExtraParams(builder);
        builder.append("})");
        this.configEvents(builder);
        builder.append(";");
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)builder));
    }

    protected void configExtraParams(StringBuilder builder) {
    }

    protected void configEvents(StringBuilder builder) {
    }

    public N getMin() {
        return this.min;
    }

    public BootstrapSlider setMin(N min) {
        this.min = min;
        return this;
    }

    public N getMax() {
        return this.max;
    }

    public BootstrapSlider setMax(N max) {
        this.max = max;
        return this;
    }

    public N getStep() {
        return this.step;
    }

    public BootstrapSlider setStep(N step) {
        this.step = step;
        return this;
    }

    public TooltipType getTooltip() {
        return this.tooltip;
    }

    public BootstrapSlider setTooltip(TooltipType tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public HandleType getHandle() {
        return this.handle;
    }

    public BootstrapSlider setHandle(HandleType handle) {
        this.handle = handle;
        return this;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public BootstrapSlider setFormatter(String formatter) {
        this.formatter = formatter;
        return this;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public BootstrapSlider setOrientation(Orientation orientation) {
        this.orientation = orientation;
        return this;
    }

    public Boolean getReversed() {
        return this.reversed;
    }

    public BootstrapSlider setReversed(Boolean reversed) {
        this.reversed = reversed;
        return this;
    }

    public Boolean getTooltipSplit() {
        return this.tooltipSplit;
    }

    public BootstrapSlider setTooltipSplit(Boolean tooltipSplit) {
        this.tooltipSplit = tooltipSplit;
        return this;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public BootstrapSlider setPrecision(Integer precision) {
        this.precision = precision;
        if (precision != null && precision < 0) {
            throw new IllegalArgumentException("Precision should be a positive number");
        }
        return this;
    }

    public Scale getScale() {
        return this.scale;
    }

    public BootstrapSlider setScale(Scale scale) {
        this.scale = scale;
        return this;
    }

    public static enum Scale {
        logarithmic,
        linear;

    }

    public static enum Orientation {
        horizontal,
        vertical;

    }

    public static enum HandleType {
        round,
        square,
        triangle,
        custom;

    }

    public static enum TooltipType {
        show,
        hide,
        always;

    }
}

