/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeahead;

import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.TextRequestHandler;
import org.apache.wicket.util.string.StringValue;

public abstract class TypeaheadBehavior<T>
extends AbstractAjaxBehavior {
    public void onRequest() {
        RequestCycle requestCycle = this.getComponent().getRequestCycle();
        Request request = requestCycle.getRequest();
        IRequestParameters parameters = request.getRequestParameters();
        StringValue input = parameters.getParameterValue("term");
        Iterable<T> choices = this.getChoices(input.toString(""));
        String jsonArray = this.createJson(choices);
        requestCycle.scheduleRequestHandlerAfterCurrent((IRequestHandler)new TextRequestHandler("application/json", "UTF-8", jsonArray));
    }

    protected String createJson(Iterable<T> choices) {
        StringBuilder json = new StringBuilder();
        json.append('[');
        for (T choice : choices) {
            if (json.length() > 1) {
                json.append(',');
            }
            json.append('\"').append(choice).append('\"');
        }
        json.append(']');
        return json.toString();
    }

    protected abstract Iterable<T> getChoices(String var1);
}

