/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery;

import de.agilecoders.wicket.jquery.CombinableConfig;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.util.Json;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConfigWithFallback
extends CombinableConfig {
    private final Config base;
    private final Config fallback;

    public ConfigWithFallback(Config base, Config fallback) {
        this.base = base;
        this.fallback = fallback;
    }

    @Override
    public String toJsonString() {
        return Json.stringify(this.all());
    }

    @Override
    public Map<String, Object> all() {
        HashMap<String, Object> all = new HashMap<String, Object>();
        all.putAll(this.fallback.all());
        all.putAll(this.base.all());
        return Collections.unmodifiableMap(all);
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty() && this.fallback.isEmpty();
    }

    @Override
    public <T> ConfigWithFallback put(IKey<T> key, T value) {
        if (this.fallback.contains(key)) {
            this.fallback.put(key, value);
        }
        this.base.put(key, value);
        return this;
    }

    @Override
    public <T> T remove(IKey<T> key) {
        T value = key.getDefaultValue();
        if (this.fallback.contains(key)) {
            value = this.fallback.remove(key);
        }
        if (this.base.contains(key)) {
            value = this.base.remove(key);
        }
        return value;
    }

    @Override
    public <T> T get(IKey<T> key) {
        if (this.base.contains(key)) {
            return this.base.get(key);
        }
        if (this.fallback.contains(key)) {
            return this.fallback.get(key);
        }
        return key.getDefaultValue();
    }

    @Override
    public <T> boolean contains(IKey<T> key) {
        return this.base.contains(key) || this.fallback.contains(key);
    }
}

