/*
 * Decompiled with CFR 0.152.
 */
package com.dashy.trace;

import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Trace {
    public static final int NONE = 1;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    private static int sLevel;
    private static boolean showCodePostion;
    private static boolean logRecord;
    private static String globalTag;
    private static String logPath;
    private static int maxLogFileSize;
    private static final int BINARY_INTEGER = 1024;
    public static final String TXT_SUFFIX = ".txt";
    private static SimpleDateFormat simpleDateFormat;
    private static int offset;

    public static void v(String tag, String message) {
        Trace.println(2, tag, message);
    }

    public static void d(String tag, String message) {
        Trace.println(3, tag, message);
    }

    public static void i(String tag, String message) {
        Trace.println(4, tag, message);
    }

    public static void w(String tag, String message) {
        Trace.println(5, tag, message);
    }

    public static void e(String tag, String message) {
        Trace.println(6, tag, message);
    }

    public static void v(String tag, String message, Object ... args) {
        Trace.println(2, tag, String.format(message, args));
    }

    public static void d(String tag, String message, Object ... args) {
        Trace.println(3, tag, String.format(message, args));
    }

    public static void i(String tag, String message, Object ... args) {
        Trace.println(4, tag, String.format(message, args));
    }

    public static void w(String tag, String message, Object ... args) {
        Trace.println(5, tag, String.format(message, args));
    }

    public static void e(String tag, String message, Object ... args) {
        Trace.println(6, tag, String.format(message, args));
    }

    private static void println(int level, String tag, String message) {
        if (level >= sLevel) {
            Trace.recordLog(tag, message);
        }
        if (showCodePostion) {
            message = message + Trace.getCodeMessage();
        }
        Trace.printAndroidLog(level, tag, message);
    }

    private static void printAndroidLog(int level, String tag, String message) {
        switch (level) {
            case 2: {
                Log.v((String)tag, (String)message);
                break;
            }
            case 3: {
                Log.d((String)tag, (String)message);
                break;
            }
            case 4: {
                Log.i((String)tag, (String)message);
                break;
            }
            case 5: {
                Log.w((String)tag, (String)message);
                break;
            }
            case 6: {
                Log.e((String)tag, (String)message);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordLog(String tag, String message) {
        File file = new File(logPath);
        if (!Trace.checkLogFile()) {
            return;
        }
        String text = Trace.getFormatLog(tag, message);
        FileOutputStream fileOutputStream = null;
        boolean append = file.length() <= (long)(maxLogFileSize * 1024);
        try {
            fileOutputStream = new FileOutputStream(file, append);
            fileOutputStream.write(text.getBytes());
            fileOutputStream.write("\n".getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean checkLogFile() {
        File file = new File(logPath);
        if (!file.exists()) {
            boolean mkParentDirs;
            if (!file.getParentFile().exists() && !(mkParentDirs = file.getParentFile().mkdirs())) {
                Log.e((String)globalTag, (String)Trace.getStackTraceString(new IOException("Can't create the directory of trace. Please check the trace path.")));
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)globalTag, (String)Trace.getStackTraceString(e));
                e.printStackTrace();
            }
        } else if (file.length() > (long)(maxLogFileSize * 1024)) {
            file.renameTo(new File(logPath.replace(TXT_SUFFIX, System.currentTimeMillis() + TXT_SUFFIX)));
        }
        return true;
    }

    private static String getStackTraceString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        for (Throwable temp = throwable; temp == null; temp = temp.getCause()) {
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private static String getFormatLog(String tag, String message) {
        String dateStr = simpleDateFormat.format(new Date());
        return dateStr + " " + String.format("%s ", Thread.currentThread().getId()) + String.format("%s: ", tag) + message;
    }

    private static String getCodeMessage() {
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        int index = 5 + offset;
        offset = 0;
        String className = stackTraceElement[index].getClassName();
        String methodName = stackTraceElement[index].getMethodName();
        int lineNumber = stackTraceElement[index].getLineNumber();
        return String.format(".(%s:%s) %s()", className, lineNumber, methodName);
    }

    static {
        maxLogFileSize = 1024;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.CHINA);
        sLevel = 1;
        showCodePostion = true;
        logRecord = true;
        globalTag = "Awesome36Kr";
        logPath = Environment.getExternalStorageDirectory() + String.format("/%s_log.txt", globalTag);
    }
}

