package com.dashy.trace;

import android.os.Environment;
import android.util.Log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * 2019/1/15
 * by Dashy
 */
public class Trace {
    public static final int NONE = 1;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;

    private static int sLevel;
    private static boolean showCodePostion;
    private static boolean logRecord;

    private static String globalTag;
    private static String logPath;
    private static int maxLogFileSize = 1024;

    private static final int BINARY_INTEGER = 1024;
    public static final String TXT_SUFFIX = ".txt";
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.CHINA);
    private static int offset;

    static {
        sLevel = NONE;
        showCodePostion = true;
        logRecord = true;
        globalTag = "Awesome36Kr";
        logPath = Environment.getExternalStorageDirectory() + String.format("/%s_log.txt", globalTag);
    }

    public static void v(String tag, String message) {
        println(VERBOSE, tag, message);
    }

    public static void d(String tag, String message) {
        println(DEBUG, tag, message);
    }

    public static void i(String tag, String message) {
        println(INFO, tag, message);
    }

    public static void w(String tag, String message) {
        println(WARN, tag, message);
    }

    public static void e(String tag, String message) {
        println(ERROR, tag, message);
    }

    public static void v(String tag, String message, Object... args) {
        println(VERBOSE, tag, String.format(message, args));
    }

    public static void d(String tag, String message, Object... args) {
        println(DEBUG, tag, String.format(message, args));
    }

    public static void i(String tag, String message, Object... args) {
        println(INFO, tag, String.format(message, args));
    }

    public static void w(String tag, String message, Object... args) {
        println(WARN, tag, String.format(message, args));
    }

    public static void e(String tag, String message, Object... args) {
        println(ERROR, tag, String.format(message, args));
    }

    private static void println(int level, String tag, String message) {
        if (level >= sLevel) {
            recordLog(tag, message);
        }
        if (showCodePostion) {
            message += getCodeMessage();
        }
        printAndroidLog(level, tag, message);
    }

    private static void printAndroidLog(int level, String tag, String message) {
        switch (level) {
            case VERBOSE:
                Log.v(tag, message);
                break;
            case DEBUG:
                Log.d(tag, message);
                break;
            case INFO:
                Log.i(tag, message);
                break;
            case WARN:
                Log.w(tag, message);
                break;
            case ERROR:
                Log.e(tag, message);
                break;
            default:
                break;
        }
    }

    private static void recordLog(String tag, String message) {
        File file = new File(logPath);
        if (!checkLogFile()) {
            return;
        }
        String text = getFormatLog(tag, message);
        FileOutputStream fileOutputStream = null;
        boolean append = file.length() <= maxLogFileSize * BINARY_INTEGER;
        try {
            fileOutputStream = new FileOutputStream(file, append);
            fileOutputStream.write(text.getBytes());
            fileOutputStream.write("\n".getBytes());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

    }

    private static boolean checkLogFile() {
        File file = new File(logPath);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                boolean mkParentDirs = file.getParentFile().mkdirs();
                if (!mkParentDirs) {
                    Log.e(globalTag, getStackTraceString(new IOException("Can't create the directory of trace. Please check the trace path.")));
                }
            }
            try {
                file.createNewFile();
            } catch (IOException e) {
                Log.e(globalTag, getStackTraceString(e));
                e.printStackTrace();
            }
        } else {
            if (file.length() > maxLogFileSize * BINARY_INTEGER) {
                file.renameTo(new File(logPath.replace(TXT_SUFFIX, System.currentTimeMillis() + TXT_SUFFIX)));
            }
        }
        return true;
    }

    private static String getStackTraceString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        Throwable temp = throwable;
        while (temp == null) {
            temp = temp.getCause();
        }

        // TODO: 2019/1/15 不知道这里为什么这么写
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private static String getFormatLog(String tag, String message) {
        String dateStr = simpleDateFormat.format(new Date());
        // TODO: 2019/1/15 获取到的线程 id 不对
        return dateStr + " " + String.format("%s ", Thread.currentThread().getId()) + String.format("%s: ", tag) + message;
    }

    private static String getCodeMessage() {
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        // TODO: 2019/1/15 不太明白 offset 的计算 & 获取到的运行代码位置不对
        int index = 5 + offset;
        offset = 0;
//        String className = stackTraceElement[index].getClassName();
//        String methodName = stackTraceElement[index].getMethodName();
//        int lineNumber = stackTraceElement[index].getLineNumber();
        String className = stackTraceElement[0].getClassName();
        String methodName = stackTraceElement[0].getMethodName();
        int lineNumber = stackTraceElement[0].getLineNumber();
        return String.format(".(%s:%s) %s()", className, lineNumber, methodName);
    }

//    private static String convertThreadId(int value){
//
//    }
}
