/*
 * Decompiled with CFR 0.152.
 */
package com.zzang.android.softkeypaddetect;

import android.app.Activity;
import android.graphics.Rect;
import android.support.v4.app.Fragment;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.zzang.android.softkeypaddetect.OnSoftKeyPadListener;

public class SoftKeyPadDetector
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final int SOFT_INPUT_MIN_HEIGHT = 200;
    private final View mView;
    private final Rect mVisibleRect = new Rect();
    private int mRectRight = 0;
    private int mVisibleHeight = 0;
    private boolean mIsVisibleSoftKeyPad = false;
    private int mSoftKeyPadHeight = 0;
    private int mStatusBarHeight = 0;
    private boolean mDetectPaused = false;
    private OnSoftKeyPadListener mOnSoftKeyPadListener;

    public SoftKeyPadDetector(View view) {
        this.mView = view;
        if (view instanceof OnSoftKeyPadListener) {
            this.setOnSoftInputListener((OnSoftKeyPadListener)view);
        }
    }

    public SoftKeyPadDetector(Activity activity) {
        this(((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0));
        if (activity instanceof OnSoftKeyPadListener) {
            this.setOnSoftInputListener((OnSoftKeyPadListener)activity);
        }
    }

    public SoftKeyPadDetector(Fragment fragment) {
        this((Activity)fragment.getActivity());
        if (fragment instanceof OnSoftKeyPadListener) {
            this.setOnSoftInputListener((OnSoftKeyPadListener)fragment);
        }
    }

    public SoftKeyPadDetector setOnSoftInputListener(OnSoftKeyPadListener onSoftKeyPadListener) {
        this.mOnSoftKeyPadListener = onSoftKeyPadListener;
        return this;
    }

    public boolean isSoftKeyPadVisible() {
        return this.mIsVisibleSoftKeyPad;
    }

    public int getSoftKeyPadHeight() {
        return this.mSoftKeyPadHeight;
    }

    public int getStatusBarHeight() {
        return this.mStatusBarHeight;
    }

    public View getView() {
        return this.mView;
    }

    public Rect getVisibleRect() {
        return this.mVisibleRect;
    }

    public int getVisibleHeight() {
        return this.mVisibleHeight;
    }

    public void startDetect() {
        this.addOnGlobalLayoutListener(this.mView, this);
        this.resumeDetect();
    }

    public void resumeDetect() {
        this.mDetectPaused = false;
    }

    public void pauseDetect() {
        this.mDetectPaused = true;
    }

    public void stopDetect() {
        this.pauseDetect();
        this.removeOnGlobalLayoutListener(this.mView, this);
    }

    public void addOnGlobalLayoutListener(View view, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver != null) {
            viewTreeObserver.addOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public void removeOnGlobalLayoutListener(View view, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver != null) {
            viewTreeObserver.removeOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public void onGlobalLayout() {
        this.mView.getWindowVisibleDisplayFrame(this.mVisibleRect);
        boolean isChangeOrientation = false;
        if (this.mRectRight == 0) {
            this.mRectRight = this.mVisibleRect.right;
        } else if (this.mRectRight != this.mVisibleRect.right) {
            isChangeOrientation = true;
            this.mRectRight = this.mVisibleRect.right;
        } else {
            isChangeOrientation = false;
        }
        int visibleHeight = this.mVisibleRect.height();
        if (!isChangeOrientation && this.mVisibleHeight != visibleHeight) {
            boolean softInputVisible;
            this.mVisibleHeight = visibleHeight;
            this.mStatusBarHeight = this.mVisibleRect.top;
            int softInputHeight = this.mView.getRootView().getHeight() - visibleHeight - this.mStatusBarHeight;
            boolean bl = softInputVisible = softInputHeight > 200;
            if (this.mIsVisibleSoftKeyPad != softInputVisible || this.mSoftKeyPadHeight != softInputHeight) {
                this.mIsVisibleSoftKeyPad = softInputVisible;
                this.mSoftKeyPadHeight = softInputHeight;
                if (this.mOnSoftKeyPadListener != null && !this.mDetectPaused) {
                    this.mOnSoftKeyPadListener.onSoftKeyPadChanged(softInputVisible, softInputHeight);
                }
            }
        }
    }
}

