/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Revenue;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class Fulfillment {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ORDER_LINE_ITEM_ID = "order_line_item_id";
    @SerializedName(value="order_line_item_id")
    private String orderLineItemId;
    public static final String SERIALIZED_NAME_FULFILLMENT_NUMBER = "fulfillment_number";
    @SerializedName(value="fulfillment_number")
    private String fulfillmentNumber;
    public static final String SERIALIZED_NAME_FULFILLMENT_DATE = "fulfillment_date";
    @SerializedName(value="fulfillment_date")
    private LocalDate fulfillmentDate;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_TRACKING_NUMBER = "tracking_number";
    @SerializedName(value="tracking_number")
    private String trackingNumber;
    public static final String SERIALIZED_NAME_CARRIER = "carrier";
    @SerializedName(value="carrier")
    private String carrier;
    public static final String SERIALIZED_NAME_FULFILLMENT_SYSTEM = "fulfillment_system";
    @SerializedName(value="fulfillment_system")
    private String fulfillmentSystem;
    public static final String SERIALIZED_NAME_EXTERNAL_ID = "external_id";
    @SerializedName(value="external_id")
    private String externalId;
    public static final String SERIALIZED_NAME_REVENUE = "revenue";
    @SerializedName(value="revenue")
    private Revenue revenue;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private Map<String, Object> location = null;

    public Fulfillment() {
    }

    public Fulfillment(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public Fulfillment customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Fulfillment putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public Fulfillment orderLineItemId(String orderLineItemId) {
        this.orderLineItemId = orderLineItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of the associated order line item.")
    public String getOrderLineItemId() {
        return this.orderLineItemId;
    }

    public void setOrderLineItemId(String orderLineItemId) {
        this.orderLineItemId = orderLineItemId;
    }

    public Fulfillment fulfillmentNumber(String fulfillmentNumber) {
        this.fulfillmentNumber = fulfillmentNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier for the object. It can be user-supplied.")
    public String getFulfillmentNumber() {
        return this.fulfillmentNumber;
    }

    public void setFulfillmentNumber(String fulfillmentNumber) {
        this.fulfillmentNumber = fulfillmentNumber;
    }

    public Fulfillment fulfillmentDate(LocalDate fulfillmentDate) {
        this.fulfillmentDate = fulfillmentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date of the fulfillment.")
    public LocalDate getFulfillmentDate() {
        return this.fulfillmentDate;
    }

    public void setFulfillmentDate(LocalDate fulfillmentDate) {
        this.fulfillmentDate = fulfillmentDate;
    }

    public Fulfillment type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of fulfillment.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Fulfillment quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of units of this item.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public Fulfillment state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of the invoice.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Fulfillment targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="All order line items associated with this fulfillment that were unbilled on or before this date are included in future bill runs.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public Fulfillment description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Fulfillment trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tracking number of the fulfillment.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public Fulfillment carrier(String carrier) {
        this.carrier = carrier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the shipping carrier for this fulfillment.")
    public String getCarrier() {
        return this.carrier;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public Fulfillment fulfillmentSystem(String fulfillmentSystem) {
        this.fulfillmentSystem = fulfillmentSystem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fulfillment system for the fulfillment.")
    public String getFulfillmentSystem() {
        return this.fulfillmentSystem;
    }

    public void setFulfillmentSystem(String fulfillmentSystem) {
        this.fulfillmentSystem = fulfillmentSystem;
    }

    public Fulfillment externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An external identifier for the fulfillment.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Fulfillment revenue(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Revenue getRevenue() {
        return this.revenue;
    }

    public void setRevenue(Revenue revenue) {
        this.revenue = revenue;
    }

    public Fulfillment location(Map<String, Object> location) {
        this.location = location;
        return this;
    }

    public Fulfillment putLocationItem(String key, Object locationItem) {
        if (this.location == null) {
            this.location = new HashMap<String, Object>();
        }
        this.location.put(key, locationItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fulfillment location of the fulfillment.")
    public Map<String, Object> getLocation() {
        return this.location;
    }

    public void setLocation(Map<String, Object> location) {
        this.location = location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fulfillment fulfillment = (Fulfillment)o;
        return Objects.equals(this.id, fulfillment.id) && Objects.equals(this.updatedById, fulfillment.updatedById) && Objects.equals(this.updatedTime, fulfillment.updatedTime) && Objects.equals(this.createdById, fulfillment.createdById) && Objects.equals(this.createdTime, fulfillment.createdTime) && Objects.equals(this.customFields, fulfillment.customFields) && Objects.equals(this.customObjects, fulfillment.customObjects) && Objects.equals(this.orderLineItemId, fulfillment.orderLineItemId) && Objects.equals(this.fulfillmentNumber, fulfillment.fulfillmentNumber) && Objects.equals(this.fulfillmentDate, fulfillment.fulfillmentDate) && Objects.equals((Object)this.type, (Object)fulfillment.type) && Objects.equals(this.quantity, fulfillment.quantity) && Objects.equals((Object)this.state, (Object)fulfillment.state) && Objects.equals(this.targetDate, fulfillment.targetDate) && Objects.equals(this.description, fulfillment.description) && Objects.equals(this.trackingNumber, fulfillment.trackingNumber) && Objects.equals(this.carrier, fulfillment.carrier) && Objects.equals(this.fulfillmentSystem, fulfillment.fulfillmentSystem) && Objects.equals(this.externalId, fulfillment.externalId) && Objects.equals(this.revenue, fulfillment.revenue) && Objects.equals(this.location, fulfillment.location);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.orderLineItemId, this.fulfillmentNumber, this.fulfillmentDate, this.type, this.quantity, this.state, this.targetDate, this.description, this.trackingNumber, this.carrier, this.fulfillmentSystem, this.externalId, this.revenue, this.location});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Fulfillment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    orderLineItemId: ").append(this.toIndentedString(this.orderLineItemId)).append("\n");
        sb.append("    fulfillmentNumber: ").append(this.toIndentedString(this.fulfillmentNumber)).append("\n");
        sb.append("    fulfillmentDate: ").append(this.toIndentedString(this.fulfillmentDate)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    carrier: ").append(this.toIndentedString(this.carrier)).append("\n");
        sb.append("    fulfillmentSystem: ").append(this.toIndentedString(this.fulfillmentSystem)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    revenue: ").append(this.toIndentedString(this.revenue)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ACCEPTED("accepted"),
        BOOKED("booked"),
        SENT_TO_BILLING("sent_to_billing"),
        COMPLETE("complete"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        DELIVERY("delivery"),
        RETURN("return"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

