/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.CcRefCard;
import org.openapitools.client.model.Mandate;

@ApiModel(description="If the `type` of the payment method is `cc_ref`, this hash contains details about the Credit Card Reference Transactions payment method. See [Supported payment methods](https://knowledgecenter.zuora.com/Billing/Billing_and_Payments/L_Payment_Methods/A_Supported_Payment_Methods) for payment gateways that support this type of payment method.")
public class CcRef {
    public static final String SERIALIZED_NAME_SECOND_TOKEN = "second_token";
    @SerializedName(value="second_token")
    private String secondToken;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private Mandate mandate;
    public static final String SERIALIZED_NAME_CARD = "card";
    @SerializedName(value="card")
    private CcRefCard card;

    public CcRef secondToken(String secondToken) {
        this.secondToken = secondToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A gateway unique identifier that replaces sensitive payment method data. This field is conditionally required only when `token` is being used to represent a gateway customer profile.")
    public String getSecondToken() {
        return this.secondToken;
    }

    public void setSecondToken(String secondToken) {
        this.secondToken = secondToken;
    }

    public CcRef token(String token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A gateway unique identifier that replaces sensitive payment method data or represents a gateway's unique customer profile. When `token` is used to represent a customer profile, `second_token` is conditionally required for representing the underlying tokenized payment method.")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public CcRef mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public CcRef card(CcRefCard card) {
        this.card = card;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CcRefCard getCard() {
        return this.card;
    }

    public void setCard(CcRefCard card) {
        this.card = card;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CcRef ccRef = (CcRef)o;
        return Objects.equals(this.secondToken, ccRef.secondToken) && Objects.equals(this.token, ccRef.token) && Objects.equals(this.mandate, ccRef.mandate) && Objects.equals(this.card, ccRef.card);
    }

    public int hashCode() {
        return Objects.hash(this.secondToken, this.token, this.mandate, this.card);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CcRef {\n");
        sb.append("    secondToken: ").append(this.toIndentedString(this.secondToken)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

