/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.Mandate;

@ApiModel(description="If the `type` of the payment method is `nz_becs_debit`, this hash contains details about the BECS-NZ bank account.")
public class NzBecsDebit {
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_BRANCH_CODE = "branch_code";
    @SerializedName(value="branch_code")
    private String branchCode;
    public static final String SERIALIZED_NAME_BANK_CODE = "bank_code";
    @SerializedName(value="bank_code")
    private String bankCode;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private Mandate mandate;

    public NzBecsDebit accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank account number of the account holder.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public NzBecsDebit branchCode(String branchCode) {
        this.branchCode = branchCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifier of the bank branch associated with this bank account.")
    public String getBranchCode() {
        return this.branchCode;
    }

    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    public NzBecsDebit bankCode(String bankCode) {
        this.bankCode = bankCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifier of the bank associated with this bank account.")
    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public NzBecsDebit mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NzBecsDebit nzBecsDebit = (NzBecsDebit)o;
        return Objects.equals(this.accountNumber, nzBecsDebit.accountNumber) && Objects.equals(this.branchCode, nzBecsDebit.branchCode) && Objects.equals(this.bankCode, nzBecsDebit.bankCode) && Objects.equals(this.mandate, nzBecsDebit.mandate);
    }

    public int hashCode() {
        return Objects.hash(this.accountNumber, this.branchCode, this.bankCode, this.mandate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NzBecsDebit {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    branchCode: ").append(this.toIndentedString(this.branchCode)).append("\n");
        sb.append("    bankCode: ").append(this.toIndentedString(this.bankCode)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

