/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.InvoiceItemListResponse;
import org.openapitools.client.model.ListQueryParams;

public class InvoiceItemsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InvoiceItemsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InvoiceItemsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getInvoiceItemsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceItemFields, List<String> taxationItemsFields, List<String> lineItemFields, String zuoraTrackId, String zuoraEntityId, String idempotencyKey, String acceptEncoding, String contentEncoding, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invoice_items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_item.fields[]", invoiceItemFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityId != null) {
            localVarHeaderParams.put("zuora-entity-id", this.localVarApiClient.parameterToString(zuoraEntityId));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInvoiceItemsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceItemFields, List<String> taxationItemsFields, List<String> lineItemFields, String zuoraTrackId, String zuoraEntityId, String idempotencyKey, String acceptEncoding, String contentEncoding, ApiCallback _callback) throws ApiException {
        return this.getInvoiceItemsCall(cursor, expand, filter, sort, pageSize, fields, invoiceItemFields, taxationItemsFields, lineItemFields, zuoraTrackId, zuoraEntityId, idempotencyKey, acceptEncoding, contentEncoding, _callback);
    }

    private ApiResponse<InvoiceItemListResponse> getInvoiceItemsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceItemFields, List<String> taxationItemsFields, List<String> lineItemFields, String zuoraTrackId, String zuoraEntityId, String idempotencyKey, String acceptEncoding, String contentEncoding) throws ApiException {
        Call localVarCall = this.getInvoiceItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, invoiceItemFields, taxationItemsFields, lineItemFields, zuoraTrackId, zuoraEntityId, idempotencyKey, acceptEncoding, contentEncoding, null);
        try {
            Type localVarReturnType = new TypeToken<InvoiceItemListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getInvoiceItemsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceItemFields, List<String> taxationItemsFields, List<String> lineItemFields, String zuoraTrackId, String zuoraEntityId, String idempotencyKey, String acceptEncoding, String contentEncoding, ApiCallback<InvoiceItemListResponse> _callback) throws ApiException {
        Call localVarCall = this.getInvoiceItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, invoiceItemFields, taxationItemsFields, lineItemFields, zuoraTrackId, zuoraEntityId, idempotencyKey, acceptEncoding, contentEncoding, _callback);
        Type localVarReturnType = new TypeToken<InvoiceItemListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetInvoiceItemsParams getInvoiceItemsParams() {
        return new GetInvoiceItemsParams();
    }

    public InvoiceItemListResponse getInvoiceItems() throws ApiException {
        GetInvoiceItemsParams params = new GetInvoiceItemsParams();
        return this.executeGetInvoiceItemsAPICall(params).getData();
    }

    public InvoiceItemListResponse getInvoiceItems(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetInvoiceItemsParams params = new GetInvoiceItemsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetInvoiceItemsAPICall(params).getData();
    }

    public InvoiceItemListResponse getInvoiceItems(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetInvoiceItemsParams params = new GetInvoiceItemsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetInvoiceItemsAPICall(params).getData();
    }

    public InvoiceItemListResponse list(GetInvoiceItemsParams params) throws ApiException {
        return this.executeGetInvoiceItemsAPICall(params).getData();
    }

    public ApiResponse<InvoiceItemListResponse> listWithHttpInfo(GetInvoiceItemsParams params) throws ApiException {
        return this.executeGetInvoiceItemsAPICall(params);
    }

    ApiResponse<InvoiceItemListResponse> executeGetInvoiceItemsAPICall(GetInvoiceItemsParams params) throws ApiException {
        return this.getInvoiceItemsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.invoiceItemFields, params.taxationItemsFields, params.lineItemFields, params.zuoraTrackId, params.zuoraEntityId, params.idempotencyKey, params.acceptEncoding, params.contentEncoding);
    }

    public static class GetInvoiceItemsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> invoiceItemFields;
        private List<String> taxationItemsFields;
        private List<String> lineItemFields;
        private String zuoraTrackId;
        private String zuoraEntityId;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;

        public GetInvoiceItemsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetInvoiceItemsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityId = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            return this;
        }

        public GetInvoiceItemsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetInvoiceItemsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetInvoiceItemsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetInvoiceItemsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetInvoiceItemsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetInvoiceItemsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetInvoiceItemsParams invoiceItemFields(List<String> invoiceItemFields) {
            this.invoiceItemFields = invoiceItemFields;
            return this;
        }

        public GetInvoiceItemsParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetInvoiceItemsParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }
    }
}

