/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.PaymentMethodTransactionLogResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class PaymentMethodTransactionLogsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentMethodTransactionLogsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentMethodTransactionLogsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getPaymentMethodTransactionLogCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String fields, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/object/payment-method-transaction-log/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentMethodTransactionLogValidateBeforeCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String fields, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getPaymentMethodTransactionLog(Async)");
        }
        return this.getPaymentMethodTransactionLogCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, fields, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PaymentMethodTransactionLogResponse getPaymentMethodTransactionLog(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String fields, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PaymentMethodTransactionLogResponse> localVarResp = this.getPaymentMethodTransactionLogWithHttpInfo(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, fields, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentMethodTransactionLogResponse> getPaymentMethodTransactionLogWithHttpInfo(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String fields, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentMethodTransactionLogValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, fields, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentMethodTransactionLogResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentMethodTransactionLogAsync(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String fields, String zuoraVersion, String zuoraOrgIds, ApiCallback<PaymentMethodTransactionLogResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentMethodTransactionLogValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, fields, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentMethodTransactionLogResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentMethodTransactionLogApi getPaymentMethodTransactionLogApi(String id) {
        return new GetPaymentMethodTransactionLogApi(id);
    }

    public class GetPaymentMethodTransactionLogApi {
        private final String id;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String fields;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetPaymentMethodTransactionLogApi(String id) {
            this.id = id;
        }

        public GetPaymentMethodTransactionLogApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentMethodTransactionLogApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentMethodTransactionLogApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentMethodTransactionLogApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentMethodTransactionLogApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentMethodTransactionLogApi fields(String fields) {
            this.fields = fields;
            return this;
        }

        public GetPaymentMethodTransactionLogApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentMethodTransactionLogApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodTransactionLogsApi.this.getPaymentMethodTransactionLogCall(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.fields, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PaymentMethodTransactionLogResponse execute() throws ApiException {
            ApiResponse<PaymentMethodTransactionLogResponse> localVarResp = PaymentMethodTransactionLogsApi.this.getPaymentMethodTransactionLogWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.fields, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PaymentMethodTransactionLogResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodTransactionLogsApi.this.getPaymentMethodTransactionLogWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.fields, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PaymentMethodTransactionLogResponse> _callback) throws ApiException {
            return PaymentMethodTransactionLogsApi.this.getPaymentMethodTransactionLogAsync(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.fields, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

