/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.BulkUpdateOrderLineItemsRequest;
import com.zuora.model.CommonResponse;
import com.zuora.model.GetBulkUpdateOrderLineItemsResponse;
import com.zuora.model.GetOrderLineItemResponse;
import com.zuora.model.UpdateOrderLineItemRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class OrderLineItemsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OrderLineItemsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrderLineItemsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getOrderLineItemCall(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean fulfillment, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/order-line-items/{itemId}".replace("{itemId}", this.localVarApiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fulfillment != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fulfillment", fulfillment));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrderLineItemValidateBeforeCall(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean fulfillment, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling getOrderLineItem(Async)");
        }
        return this.getOrderLineItemCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, fulfillment, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetOrderLineItemResponse getOrderLineItem(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean fulfillment, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetOrderLineItemResponse> localVarResp = this.getOrderLineItemWithHttpInfo(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, fulfillment, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetOrderLineItemResponse> getOrderLineItemWithHttpInfo(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean fulfillment, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getOrderLineItemValidateBeforeCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, fulfillment, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetOrderLineItemResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getOrderLineItemAsync(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean fulfillment, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetOrderLineItemResponse> _callback) throws ApiException {
        Call localVarCall = this.getOrderLineItemValidateBeforeCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, fulfillment, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetOrderLineItemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOrderLineItemApi getOrderLineItemApi(String itemId) {
        return new GetOrderLineItemApi(itemId);
    }

    private Call updateOrderLineItemCall(String itemId, UpdateOrderLineItemRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateOrderLineItemRequest localVarPostBody = body;
        String localVarPath = "/v1/order-line-items/{itemId}".replace("{itemId}", this.localVarApiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateOrderLineItemValidateBeforeCall(String itemId, UpdateOrderLineItemRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling updateOrderLineItem(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateOrderLineItem(Async)");
        }
        return this.updateOrderLineItemCall(itemId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse updateOrderLineItem(String itemId, UpdateOrderLineItemRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.updateOrderLineItemWithHttpInfo(itemId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> updateOrderLineItemWithHttpInfo(String itemId, UpdateOrderLineItemRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateOrderLineItemValidateBeforeCall(itemId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateOrderLineItemAsync(String itemId, UpdateOrderLineItemRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.updateOrderLineItemValidateBeforeCall(itemId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateOrderLineItemApi updateOrderLineItemApi(String itemId, UpdateOrderLineItemRequest body) {
        return new UpdateOrderLineItemApi(itemId, body);
    }

    private Call updateOrderLineItemsCall(BulkUpdateOrderLineItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BulkUpdateOrderLineItemsRequest localVarPostBody = body;
        String localVarPath = "/v1/order-line-items/bulk";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateOrderLineItemsValidateBeforeCall(BulkUpdateOrderLineItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateOrderLineItems(Async)");
        }
        return this.updateOrderLineItemsCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetBulkUpdateOrderLineItemsResponse updateOrderLineItems(BulkUpdateOrderLineItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetBulkUpdateOrderLineItemsResponse> localVarResp = this.updateOrderLineItemsWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetBulkUpdateOrderLineItemsResponse> updateOrderLineItemsWithHttpInfo(BulkUpdateOrderLineItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateOrderLineItemsValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetBulkUpdateOrderLineItemsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateOrderLineItemsAsync(BulkUpdateOrderLineItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetBulkUpdateOrderLineItemsResponse> _callback) throws ApiException {
        Call localVarCall = this.updateOrderLineItemsValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetBulkUpdateOrderLineItemsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateOrderLineItemsApi updateOrderLineItemsApi(BulkUpdateOrderLineItemsRequest body) {
        return new UpdateOrderLineItemsApi(body);
    }

    public class UpdateOrderLineItemsApi {
        private final BulkUpdateOrderLineItemsRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateOrderLineItemsApi(BulkUpdateOrderLineItemsRequest body) {
            this.body = body;
        }

        public UpdateOrderLineItemsApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public UpdateOrderLineItemsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateOrderLineItemsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateOrderLineItemsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateOrderLineItemsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateOrderLineItemsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateOrderLineItemsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateOrderLineItemsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrderLineItemsApi.this.updateOrderLineItemsCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetBulkUpdateOrderLineItemsResponse execute() throws ApiException {
            ApiResponse<GetBulkUpdateOrderLineItemsResponse> localVarResp = OrderLineItemsApi.this.updateOrderLineItemsWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetBulkUpdateOrderLineItemsResponse> executeWithHttpInfo() throws ApiException {
            return OrderLineItemsApi.this.updateOrderLineItemsWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetBulkUpdateOrderLineItemsResponse> _callback) throws ApiException {
            return OrderLineItemsApi.this.updateOrderLineItemsAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UpdateOrderLineItemApi {
        private final String itemId;
        private final UpdateOrderLineItemRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateOrderLineItemApi(String itemId, UpdateOrderLineItemRequest body) {
            this.itemId = itemId;
            this.body = body;
        }

        public UpdateOrderLineItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateOrderLineItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateOrderLineItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateOrderLineItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateOrderLineItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateOrderLineItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateOrderLineItemApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrderLineItemsApi.this.updateOrderLineItemCall(this.itemId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = OrderLineItemsApi.this.updateOrderLineItemWithHttpInfo(this.itemId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return OrderLineItemsApi.this.updateOrderLineItemWithHttpInfo(this.itemId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return OrderLineItemsApi.this.updateOrderLineItemAsync(this.itemId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetOrderLineItemApi {
        private final String itemId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Boolean fulfillment;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetOrderLineItemApi(String itemId) {
            this.itemId = itemId;
        }

        public GetOrderLineItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetOrderLineItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetOrderLineItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetOrderLineItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetOrderLineItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetOrderLineItemApi fulfillment(Boolean fulfillment) {
            this.fulfillment = fulfillment;
            return this;
        }

        public GetOrderLineItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetOrderLineItemApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrderLineItemsApi.this.getOrderLineItemCall(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.fulfillment, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetOrderLineItemResponse execute() throws ApiException {
            ApiResponse<GetOrderLineItemResponse> localVarResp = OrderLineItemsApi.this.getOrderLineItemWithHttpInfo(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.fulfillment, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetOrderLineItemResponse> executeWithHttpInfo() throws ApiException {
            return OrderLineItemsApi.this.getOrderLineItemWithHttpInfo(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.fulfillment, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetOrderLineItemResponse> _callback) throws ApiException {
            return OrderLineItemsApi.this.getOrderLineItemAsync(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.fulfillment, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

