/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class Headers {
    public static final String SERIALIZED_NAME_ZUORA_TRACK_ID = "zuora-track-id";
    @SerializedName(value="zuora-track-id")
    private String zuoraTrackId;
    public static final String SERIALIZED_NAME_ASYNC = "async";
    @SerializedName(value="async")
    private Boolean async = false;
    public static final String SERIALIZED_NAME_ZUORA_CACHE_ENABLED = "zuora-cache-enabled";
    @SerializedName(value="zuora-cache-enabled")
    private Boolean zuoraCacheEnabled = false;
    public static final String SERIALIZED_NAME_ZUORA_ENTITY_IDS = "zuora-entity-ids";
    @SerializedName(value="zuora-entity-ids")
    private String zuoraEntityIds;
    public static final String SERIALIZED_NAME_IDEMPOTENCY_KEY = "idempotency-key";
    @SerializedName(value="idempotency-key")
    private String idempotencyKey;
    public static final String SERIALIZED_NAME_ACCEPT_ENCODING = "accept-encoding";
    @SerializedName(value="accept-encoding")
    private String acceptEncoding;
    public static final String SERIALIZED_NAME_CONTENT_ENCODING = "content-encoding";
    @SerializedName(value="content-encoding")
    private String contentEncoding;
    public static final String SERIALIZED_NAME_ZUORA_ORG_IDS = "zuora-org-ids";
    @SerializedName(value="zuora-org-ids")
    private String zuoraOrgIds;

    public Headers zuoraTrackId(String zuoraTrackId) {
        this.zuoraTrackId = zuoraTrackId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A custom identifier for tracking API requests. If you set a value for this header, Zuora returns the same value in the response header. This header enables you to track your API calls to assist with troubleshooting in the event of an issue. The value of this field must use the US-ASCII character set and must not include any of the following characters: colon (:), semicolon (;), double quote (\"), or quote (').")
    public String getZuoraTrackId() {
        return this.zuoraTrackId;
    }

    public void setZuoraTrackId(String zuoraTrackId) {
        this.zuoraTrackId = zuoraTrackId;
    }

    public Headers async(Boolean async) {
        this.async = async;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Making asynchronous requests allows you to scale your applications more efficiently by leveraging Zuora's infrastructure to enqueue and execute requests for you without blocking. These requests also use built-in retry semantics, which makes them much less likely to fail for non-deterministic reasons, even in extreme high-throughput scenarios. Meanwhile, when you send a request to one of these endpoints, you can expect to receive a response in less than 150 milliseconds and these calls are unlikely to trigger rate limit errors. If set to true, Zuora returns a 202 Accepted response, and the response body contains only a request ID.")
    public Boolean getAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public Headers zuoraCacheEnabled(Boolean zuoraCacheEnabled) {
        this.zuoraCacheEnabled = zuoraCacheEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="It indicates whether the Zuora cache is enabled to store the request and response for the purpose of performance improvement.")
    public Boolean getZuoraCacheEnabled() {
        return this.zuoraCacheEnabled;
    }

    public void setZuoraCacheEnabled(Boolean zuoraCacheEnabled) {
        this.zuoraCacheEnabled = zuoraCacheEnabled;
    }

    public Headers zuoraEntityIds(String zuoraEntityIds) {
        this.zuoraEntityIds = zuoraEntityIds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An entity ID. If you have multi-entity enabled and the authorization token is valid for more than one entity, you must use this header to specify which entity to perform the operation on. If the authorization token is only valid for a single entity, or you do not have multi-entity enabled, you do not need to set this header.")
    public String getZuoraEntityIds() {
        return this.zuoraEntityIds;
    }

    public void setZuoraEntityIds(String zuoraEntityIds) {
        this.zuoraEntityIds = zuoraEntityIds;
    }

    public Headers idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify a unique idempotency key if you want to perform an idempotent POST or PATCH request. Do not use this header in other request types. This idempotency key should be a unique value, and the Zuora server identifies subsequent retries of the same request using this value. For more information, see [Idempotent Requests](https://developer.zuora.com/api-references/quickstart-api/tag/Idempotent-Requests/).")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public Headers acceptEncoding(String acceptEncoding) {
        this.acceptEncoding = acceptEncoding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include a `accept-encoding: gzip` header to compress responses, which can reduce the bandwidth required for a response. If specified, Zuora automatically compresses responses that contain over 1000 bytes. For more information about this header, see [Request and Response Compression](https://developer.zuora.com/api-references/quickstart-api/tag/Request-and-Response-Compression/).")
    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public void setAcceptEncoding(String acceptEncoding) {
        this.acceptEncoding = acceptEncoding;
    }

    public Headers contentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include a `content-encoding: gzip` header to compress a request. Upload a gzipped file for the payload if you specify this header. For more information, see [Request and Response Compression](https://developer.zuora.com/api-references/quickstart-api/tag/Request-and-Response-Compression/).")
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public Headers zuoraOrgIds(String zuoraOrgIds) {
        this.zuoraOrgIds = zuoraOrgIds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A comma-separated list of organization IDs. If you have multi-org enabled, you can use this header to limit the data scope to the specified organizations.")
    public String getZuoraOrgIds() {
        return this.zuoraOrgIds;
    }

    public void setZuoraOrgIds(String zuoraOrgIds) {
        this.zuoraOrgIds = zuoraOrgIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Headers headers = (Headers)o;
        return Objects.equals(this.zuoraTrackId, headers.zuoraTrackId) && Objects.equals(this.async, headers.async) && Objects.equals(this.zuoraCacheEnabled, headers.zuoraCacheEnabled) && Objects.equals(this.zuoraEntityIds, headers.zuoraEntityIds) && Objects.equals(this.idempotencyKey, headers.idempotencyKey) && Objects.equals(this.acceptEncoding, headers.acceptEncoding) && Objects.equals(this.contentEncoding, headers.contentEncoding) && Objects.equals(this.zuoraOrgIds, headers.zuoraOrgIds);
    }

    public int hashCode() {
        return Objects.hash(this.zuoraTrackId, this.async, this.zuoraCacheEnabled, this.zuoraEntityIds, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraOrgIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Headers {\n");
        sb.append("    zuoraTrackId: ").append(this.toIndentedString(this.zuoraTrackId)).append("\n");
        sb.append("    async: ").append(this.toIndentedString(this.async)).append("\n");
        sb.append("    zuoraCacheEnabled: ").append(this.toIndentedString(this.zuoraCacheEnabled)).append("\n");
        sb.append("    zuoraEntityIds: ").append(this.toIndentedString(this.zuoraEntityIds)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    acceptEncoding: ").append(this.toIndentedString(this.acceptEncoding)).append("\n");
        sb.append("    contentEncoding: ").append(this.toIndentedString(this.contentEncoding)).append("\n");
        sb.append("    zuoraOrgIds: ").append(this.toIndentedString(this.zuoraOrgIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

