/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client;

import java.util.List;
import java.util.Map;

public class ApiResponse<T> {
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final T data;
    private final boolean asyncResponse;
    private final String zuoraRequestId;

    public ApiResponse(int statusCode, Map<String, List<String>> headers) {
        this(statusCode, headers, null);
    }

    public ApiResponse(int statusCode, Map<String, List<String>> headers, T data) {
        this.statusCode = statusCode;
        String zuoraRequestId = "";
        boolean rerouted = false;
        this.headers = headers;
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (entry.getKey().toLowerCase().equals("zuora-request-id")) {
                zuoraRequestId = entry.getValue().iterator().next();
            }
            if (!entry.getKey().toLowerCase().equals("zuora-rerouted-to-async")) continue;
            rerouted = true;
        }
        this.data = data;
        this.zuoraRequestId = zuoraRequestId;
        this.asyncResponse = rerouted;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public T getData() {
        return this.data;
    }

    public String getZuoraRequestId() {
        return this.zuoraRequestId;
    }

    public boolean isAsyncResponse() {
        return this.asyncResponse;
    }
}

