/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QueryRunCreateRequest {
    public static final String SERIALIZED_NAME_COLUMN_SEPARATOR = "column_separator";
    @SerializedName(value="column_separator")
    private String columnSeparator;
    public static final String SERIALIZED_NAME_CONTENT_ENCODING = "content_encoding";
    @SerializedName(value="content_encoding")
    private ContentEncodingEnum contentEncoding;
    public static final String SERIALIZED_NAME_ENCRYPTION_KEY = "encryption_key";
    @SerializedName(value="encryption_key")
    private String encryptionKey;
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "content_type";
    @SerializedName(value="content_type")
    private ContentTypeEnum contentType;
    public static final String SERIALIZED_NAME_SQL = "sql";
    @SerializedName(value="sql")
    private String sql;
    public static final String SERIALIZED_NAME_READ_DELETED = "read_deleted";
    @SerializedName(value="read_deleted")
    private Boolean readDeleted;

    public QueryRunCreateRequest columnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The character used as delimiter to separate values in the output file.")
    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public QueryRunCreateRequest contentEncoding(ContentEncodingEnum contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If supplied, Zuora with compress the output file using the specified compression algorithm.")
    public ContentEncodingEnum getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(ContentEncodingEnum contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public QueryRunCreateRequest encryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64-encoded public key of a 1024-bit RSA key-pair. If you set this field, Zuora will encrypt the query results using the provided public key. You must use the corresponding private key to decrypt the query results.")
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public QueryRunCreateRequest contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of the file returned.")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public QueryRunCreateRequest sql(String sql) {
        this.sql = sql;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The SQL statement of the query.")
    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public QueryRunCreateRequest readDeleted(Boolean readDeleted) {
        this.readDeleted = readDeleted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, any deleted records are included in the response.")
    public Boolean getReadDeleted() {
        return this.readDeleted;
    }

    public void setReadDeleted(Boolean readDeleted) {
        this.readDeleted = readDeleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRunCreateRequest queryRunCreateRequest = (QueryRunCreateRequest)o;
        return Objects.equals(this.columnSeparator, queryRunCreateRequest.columnSeparator) && Objects.equals((Object)this.contentEncoding, (Object)queryRunCreateRequest.contentEncoding) && Objects.equals(this.encryptionKey, queryRunCreateRequest.encryptionKey) && Objects.equals((Object)this.contentType, (Object)queryRunCreateRequest.contentType) && Objects.equals(this.sql, queryRunCreateRequest.sql) && Objects.equals(this.readDeleted, queryRunCreateRequest.readDeleted);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnSeparator, this.contentEncoding, this.encryptionKey, this.contentType, this.sql, this.readDeleted});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryRunCreateRequest {\n");
        sb.append("    columnSeparator: ").append(this.toIndentedString(this.columnSeparator)).append("\n");
        sb.append("    contentEncoding: ").append(this.toIndentedString((Object)this.contentEncoding)).append("\n");
        sb.append("    encryptionKey: ").append(this.toIndentedString(this.encryptionKey)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    sql: ").append(this.toIndentedString(this.sql)).append("\n");
        sb.append("    readDeleted: ").append(this.toIndentedString(this.readDeleted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContentTypeEnum {
        JSON("json"),
        CSV("csv"),
        TSV("tsv"),
        DSV("dsv"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContentTypeEnum fromValue(String value) {
            for (ContentTypeEnum b : ContentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ContentTypeEnum> {
            public void write(JsonWriter jsonWriter, ContentTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ContentTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContentTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContentEncodingEnum {
        GZIP("gzip"),
        ZIP("zip"),
        NONE("none"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ContentEncodingEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContentEncodingEnum fromValue(String value) {
            for (ContentEncodingEnum b : ContentEncodingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ContentEncodingEnum> {
            public void write(JsonWriter jsonWriter, ContentEncodingEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ContentEncodingEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContentEncodingEnum.fromValue(value);
            }
        }
    }
}

