/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.AccountContactPatchRequest;
import org.openapitools.client.model.BillingDocumentSettings;
import org.openapitools.client.model.TaxCertificate;
import org.openapitools.client.model.TaxIdentifier;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.OffsetDateTime;

public class AccountPatchRequest {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_SETTINGS = "billing_document_settings";
    @SerializedName(value="billing_document_settings")
    private BillingDocumentSettings billingDocumentSettings;
    public static final String SERIALIZED_NAME_BATCH = "batch";
    @SerializedName(value="batch")
    private String batch;
    public static final String SERIALIZED_NAME_BILL_CYCLE_DAY = "bill_cycle_day";
    @SerializedName(value="bill_cycle_day")
    private Integer billCycleDay;
    public static final String SERIALIZED_NAME_BILL_TO = "bill_to";
    @SerializedName(value="bill_to")
    private AccountContactPatchRequest billTo;
    public static final String SERIALIZED_NAME_BILL_TO_ID = "bill_to_id";
    @SerializedName(value="bill_to_id")
    private String billToId;
    public static final String SERIALIZED_NAME_SOLD_TO = "sold_to";
    @SerializedName(value="sold_to")
    private AccountContactPatchRequest soldTo;
    public static final String SERIALIZED_NAME_SOLD_TO_ID = "sold_to_id";
    @SerializedName(value="sold_to_id")
    private String soldToId;
    public static final String SERIALIZED_NAME_COMMUNICATION_PROFILE_ID = "communication_profile_id";
    @SerializedName(value="communication_profile_id")
    private String communicationProfileId;
    public static final String SERIALIZED_NAME_CRM_ID = "crm_id";
    @SerializedName(value="crm_id")
    private String crmId;
    public static final String SERIALIZED_NAME_DEFAULT_PAYMENT_METHOD_ID = "default_payment_method_id";
    @SerializedName(value="default_payment_method_id")
    private String defaultPaymentMethodId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PARENT_ACCOUNT_ID = "parent_account_id";
    @SerializedName(value="parent_account_id")
    private String parentAccountId;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY = "payment_gateway";
    @SerializedName(value="payment_gateway")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String paymentGateway;
    public static final String SERIALIZED_NAME_PAYMENT_TERMS = "payment_terms";
    @SerializedName(value="payment_terms")
    private String paymentTerms;
    public static final String SERIALIZED_NAME_SEQUENCE_SET_ID = "sequence_set_id";
    @SerializedName(value="sequence_set_id")
    private String sequenceSetId;
    public static final String SERIALIZED_NAME_AUTO_PAY = "auto_pay";
    @SerializedName(value="auto_pay")
    private Boolean autoPay;
    public static final String SERIALIZED_NAME_TAX_CERTIFICATE = "tax_certificate";
    @SerializedName(value="tax_certificate")
    private TaxCertificate taxCertificate;
    public static final String SERIALIZED_NAME_TAX_IDENTIFIER = "tax_identifier";
    @SerializedName(value="tax_identifier")
    private TaxIdentifier taxIdentifier;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_SALES_REP = "sales_rep";
    @SerializedName(value="sales_rep")
    private String salesRep;

    public AccountPatchRequest() {
    }

    public AccountPatchRequest(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public AccountPatchRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public AccountPatchRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public AccountPatchRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A-100001", value="Human-readable identifier of the account. It can be user-supplied.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public AccountPatchRequest billingDocumentSettings(BillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BillingDocumentSettings getBillingDocumentSettings() {
        return this.billingDocumentSettings;
    }

    public void setBillingDocumentSettings(BillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
    }

    public AccountPatchRequest batch(String batch) {
        this.batch = batch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of a bill run batch.")
    public String getBatch() {
        return this.batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public AccountPatchRequest billCycleDay(Integer billCycleDay) {
        this.billCycleDay = billCycleDay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The day of the month on which your customer will be invoiced. For month-end specify 31.")
    public Integer getBillCycleDay() {
        return this.billCycleDay;
    }

    public void setBillCycleDay(Integer billCycleDay) {
        this.billCycleDay = billCycleDay;
    }

    public AccountPatchRequest billTo(AccountContactPatchRequest billTo) {
        this.billTo = billTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Customer billing address.")
    public AccountContactPatchRequest getBillTo() {
        return this.billTo;
    }

    public void setBillTo(AccountContactPatchRequest billTo) {
        this.billTo = billTo;
    }

    public AccountPatchRequest billToId(String billToId) {
        this.billToId = billToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0946a6dffc0016a7faab604299b", value="Bill To Contact Id")
    public String getBillToId() {
        return this.billToId;
    }

    public void setBillToId(String billToId) {
        this.billToId = billToId;
    }

    public AccountPatchRequest soldTo(AccountContactPatchRequest soldTo) {
        this.soldTo = soldTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Customer address used for calculating tax.")
    public AccountContactPatchRequest getSoldTo() {
        return this.soldTo;
    }

    public void setSoldTo(AccountContactPatchRequest soldTo) {
        this.soldTo = soldTo;
    }

    public AccountPatchRequest soldToId(String soldToId) {
        this.soldToId = soldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0946a6dffc0016a7faab604299b", value="Sold To Contact Id")
    public String getSoldToId() {
        return this.soldToId;
    }

    public void setSoldToId(String soldToId) {
        this.soldToId = soldToId;
    }

    public AccountPatchRequest communicationProfileId(String communicationProfileId) {
        this.communicationProfileId = communicationProfileId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0946a6dffc0016a7faab604299b", value="Identifier of the communication profile associated with this customer.")
    public String getCommunicationProfileId() {
        return this.communicationProfileId;
    }

    public void setCommunicationProfileId(String communicationProfileId) {
        this.communicationProfileId = communicationProfileId;
    }

    public AccountPatchRequest crmId(String crmId) {
        this.crmId = crmId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1a2b3c4d5e", value="CRM account identifier.")
    public String getCrmId() {
        return this.crmId;
    }

    public void setCrmId(String crmId) {
        this.crmId = crmId;
    }

    public AccountPatchRequest defaultPaymentMethodId(String defaultPaymentMethodId) {
        this.defaultPaymentMethodId = defaultPaymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8a95b1946b6aeac8718c32aab8c395f", value="Identifier of the default payment method on the customer account.")
    public String getDefaultPaymentMethodId() {
        return this.defaultPaymentMethodId;
    }

    public void setDefaultPaymentMethodId(String defaultPaymentMethodId) {
        this.defaultPaymentMethodId = defaultPaymentMethodId;
    }

    public AccountPatchRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="test account", value="The name of the customer account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccountPatchRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of test account", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AccountPatchRequest parentAccountId(String parentAccountId) {
        this.parentAccountId = parentAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093f27d6eee80017d6effd7a66759", value="Identifier of this customer's parent account, if any.")
    public String getParentAccountId() {
        return this.parentAccountId;
    }

    public void setParentAccountId(String parentAccountId) {
        this.parentAccountId = parentAccountId;
    }

    public AccountPatchRequest paymentGateway(String paymentGateway) {
        this.paymentGateway = paymentGateway;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="adyen gateway", value="Payment gateway name.")
    public String getPaymentGateway() {
        return this.paymentGateway;
    }

    public void setPaymentGateway(String paymentGateway) {
        this.paymentGateway = paymentGateway;
    }

    public AccountPatchRequest paymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Net 30", value="Payment terms configured in **Billing Settings > Payment Terms** of your Zuora tenant.")
    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public AccountPatchRequest sequenceSetId(String sequenceSetId) {
        this.sequenceSetId = sequenceSetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92a4204a6dffc0016a7faab723041c", value="The identifier or the billing document sequence set that is assigned to the customer account.")
    public String getSequenceSetId() {
        return this.sequenceSetId;
    }

    public void setSequenceSetId(String sequenceSetId) {
        this.sequenceSetId = sequenceSetId;
    }

    public AccountPatchRequest autoPay(Boolean autoPay) {
        this.autoPay = autoPay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Controls whether future payments are automatically billed when they are due.")
    public Boolean getAutoPay() {
        return this.autoPay;
    }

    public void setAutoPay(Boolean autoPay) {
        this.autoPay = autoPay;
    }

    public AccountPatchRequest taxCertificate(TaxCertificate taxCertificate) {
        this.taxCertificate = taxCertificate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaxCertificate getTaxCertificate() {
        return this.taxCertificate;
    }

    public void setTaxCertificate(TaxCertificate taxCertificate) {
        this.taxCertificate = taxCertificate;
    }

    public AccountPatchRequest taxIdentifier(TaxIdentifier taxIdentifier) {
        this.taxIdentifier = taxIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaxIdentifier getTaxIdentifier() {
        return this.taxIdentifier;
    }

    public void setTaxIdentifier(TaxIdentifier taxIdentifier) {
        this.taxIdentifier = taxIdentifier;
    }

    public AccountPatchRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Three-letter ISO currency code. Once the currency is set for an account, it cannot be updated.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public AccountPatchRequest salesRep(String salesRep) {
        this.salesRep = salesRep;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Max", value="The name of the sales representative associated with this account")
    public String getSalesRep() {
        return this.salesRep;
    }

    public void setSalesRep(String salesRep) {
        this.salesRep = salesRep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountPatchRequest accountPatchRequest = (AccountPatchRequest)o;
        return Objects.equals(this.id, accountPatchRequest.id) && Objects.equals(this.updatedById, accountPatchRequest.updatedById) && Objects.equals(this.updatedTime, accountPatchRequest.updatedTime) && Objects.equals(this.createdById, accountPatchRequest.createdById) && Objects.equals(this.createdTime, accountPatchRequest.createdTime) && Objects.equals(this.customFields, accountPatchRequest.customFields) && Objects.equals(this.customObjects, accountPatchRequest.customObjects) && Objects.equals(this.accountNumber, accountPatchRequest.accountNumber) && Objects.equals(this.billingDocumentSettings, accountPatchRequest.billingDocumentSettings) && Objects.equals(this.batch, accountPatchRequest.batch) && Objects.equals(this.billCycleDay, accountPatchRequest.billCycleDay) && Objects.equals(this.billTo, accountPatchRequest.billTo) && Objects.equals(this.billToId, accountPatchRequest.billToId) && Objects.equals(this.soldTo, accountPatchRequest.soldTo) && Objects.equals(this.soldToId, accountPatchRequest.soldToId) && Objects.equals(this.communicationProfileId, accountPatchRequest.communicationProfileId) && Objects.equals(this.crmId, accountPatchRequest.crmId) && Objects.equals(this.defaultPaymentMethodId, accountPatchRequest.defaultPaymentMethodId) && Objects.equals(this.name, accountPatchRequest.name) && Objects.equals(this.description, accountPatchRequest.description) && Objects.equals(this.parentAccountId, accountPatchRequest.parentAccountId) && Objects.equals(this.paymentGateway, accountPatchRequest.paymentGateway) && Objects.equals(this.paymentTerms, accountPatchRequest.paymentTerms) && Objects.equals(this.sequenceSetId, accountPatchRequest.sequenceSetId) && Objects.equals(this.autoPay, accountPatchRequest.autoPay) && Objects.equals(this.taxCertificate, accountPatchRequest.taxCertificate) && Objects.equals(this.taxIdentifier, accountPatchRequest.taxIdentifier) && Objects.equals(this.currency, accountPatchRequest.currency) && Objects.equals(this.salesRep, accountPatchRequest.salesRep);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.accountNumber, this.billingDocumentSettings, this.batch, this.billCycleDay, this.billTo, this.billToId, this.soldTo, this.soldToId, this.communicationProfileId, this.crmId, this.defaultPaymentMethodId, this.name, this.description, this.parentAccountId, this.paymentGateway, this.paymentTerms, this.sequenceSetId, this.autoPay, this.taxCertificate, this.taxIdentifier, this.currency, this.salesRep);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountPatchRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    billingDocumentSettings: ").append(this.toIndentedString(this.billingDocumentSettings)).append("\n");
        sb.append("    batch: ").append(this.toIndentedString(this.batch)).append("\n");
        sb.append("    billCycleDay: ").append(this.toIndentedString(this.billCycleDay)).append("\n");
        sb.append("    billTo: ").append(this.toIndentedString(this.billTo)).append("\n");
        sb.append("    billToId: ").append(this.toIndentedString(this.billToId)).append("\n");
        sb.append("    soldTo: ").append(this.toIndentedString(this.soldTo)).append("\n");
        sb.append("    soldToId: ").append(this.toIndentedString(this.soldToId)).append("\n");
        sb.append("    communicationProfileId: ").append(this.toIndentedString(this.communicationProfileId)).append("\n");
        sb.append("    crmId: ").append(this.toIndentedString(this.crmId)).append("\n");
        sb.append("    defaultPaymentMethodId: ").append(this.toIndentedString(this.defaultPaymentMethodId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    parentAccountId: ").append(this.toIndentedString(this.parentAccountId)).append("\n");
        sb.append("    paymentGateway: ").append(this.toIndentedString(this.paymentGateway)).append("\n");
        sb.append("    paymentTerms: ").append(this.toIndentedString(this.paymentTerms)).append("\n");
        sb.append("    sequenceSetId: ").append(this.toIndentedString(this.sequenceSetId)).append("\n");
        sb.append("    autoPay: ").append(this.toIndentedString(this.autoPay)).append("\n");
        sb.append("    taxCertificate: ").append(this.toIndentedString(this.taxCertificate)).append("\n");
        sb.append("    taxIdentifier: ").append(this.toIndentedString(this.taxIdentifier)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    salesRep: ").append(this.toIndentedString(this.salesRep)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

