/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.BillingDocument;
import org.openapitools.client.model.PaymentAppliedToBillingItemResponse;
import org.openapitools.jackson.nullable.JsonNullable;

public class PaymentsAppliedToResponse {
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_ID = "billing_document_id";
    @SerializedName(value="billing_document_id")
    private String billingDocumentId;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT = "billing_document";
    @SerializedName(value="billing_document")
    private BillingDocument billingDocument;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_TYPE = "billing_document_type";
    @SerializedName(value="billing_document_type")
    private BillingDocumentTypeEnum billingDocumentType;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<PaymentAppliedToBillingItemResponse> items = null;

    public PaymentsAppliedToResponse() {
    }

    public PaymentsAppliedToResponse(StateEnum state) {
        this();
        this.state = state;
    }

    public PaymentsAppliedToResponse billingDocumentId(String billingDocumentId) {
        this.billingDocumentId = billingDocumentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of an invoice or a debit memo.")
    public String getBillingDocumentId() {
        return this.billingDocumentId;
    }

    public void setBillingDocumentId(String billingDocumentId) {
        this.billingDocumentId = billingDocumentId;
    }

    public PaymentsAppliedToResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payment application.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PaymentsAppliedToResponse amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the payment that is applied to the specific billing document item or taxation item.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public PaymentsAppliedToResponse billingDocument(BillingDocument billingDocument) {
        this.billingDocument = billingDocument;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The related billing document.")
    public BillingDocument getBillingDocument() {
        return this.billingDocument;
    }

    public void setBillingDocument(BillingDocument billingDocument) {
        this.billingDocument = billingDocument;
    }

    public PaymentsAppliedToResponse billingDocumentType(BillingDocumentTypeEnum billingDocumentType) {
        this.billingDocumentType = billingDocumentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of billing document. Can be one of the debit memo or invoice.")
    public BillingDocumentTypeEnum getBillingDocumentType() {
        return this.billingDocumentType;
    }

    public void setBillingDocumentType(BillingDocumentTypeEnum billingDocumentType) {
        this.billingDocumentType = billingDocumentType;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StateEnum getState() {
        return this.state;
    }

    public PaymentsAppliedToResponse items(List<PaymentAppliedToBillingItemResponse> items) {
        this.items = items;
        return this;
    }

    public PaymentsAppliedToResponse addItemsItem(PaymentAppliedToBillingItemResponse itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<PaymentAppliedToBillingItemResponse>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The related billing document item.")
    public List<PaymentAppliedToBillingItemResponse> getItems() {
        return this.items;
    }

    public void setItems(List<PaymentAppliedToBillingItemResponse> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentsAppliedToResponse paymentsAppliedToResponse = (PaymentsAppliedToResponse)o;
        return Objects.equals(this.billingDocumentId, paymentsAppliedToResponse.billingDocumentId) && Objects.equals(this.id, paymentsAppliedToResponse.id) && Objects.equals(this.amount, paymentsAppliedToResponse.amount) && Objects.equals(this.billingDocument, paymentsAppliedToResponse.billingDocument) && Objects.equals((Object)this.billingDocumentType, (Object)paymentsAppliedToResponse.billingDocumentType) && Objects.equals((Object)this.state, (Object)paymentsAppliedToResponse.state) && Objects.equals(this.items, paymentsAppliedToResponse.items);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.billingDocumentId, this.id, this.amount, this.billingDocument, this.billingDocumentType, this.state, this.items});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentsAppliedToResponse {\n");
        sb.append("    billingDocumentId: ").append(this.toIndentedString(this.billingDocumentId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    billingDocument: ").append(this.toIndentedString(this.billingDocument)).append("\n");
        sb.append("    billingDocumentType: ").append(this.toIndentedString((Object)this.billingDocumentType)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        DRAFT("draft"),
        POSTED("posted"),
        PROCESSING("processing"),
        PROCESSED("processed"),
        ERROR("error"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BillingDocumentTypeEnum {
        DEBIT_MEMO("debit_memo"),
        INVOICE("invoice"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private BillingDocumentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BillingDocumentTypeEnum fromValue(String value) {
            for (BillingDocumentTypeEnum b : BillingDocumentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BillingDocumentTypeEnum> {
            public void write(JsonWriter jsonWriter, BillingDocumentTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BillingDocumentTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BillingDocumentTypeEnum.fromValue(value);
            }
        }
    }
}

