/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Account;
import org.openapitools.client.model.AchDebit;
import org.openapitools.client.model.ApplePay;
import org.openapitools.client.model.AuBecsDebit;
import org.openapitools.client.model.AutogiroDebit;
import org.openapitools.client.model.BacsDebit;
import org.openapitools.client.model.BetalingsDebit;
import org.openapitools.client.model.BillingDetails;
import org.openapitools.client.model.CcRef;
import org.openapitools.client.model.GetCardList;
import org.openapitools.client.model.GooglePay;
import org.openapitools.client.model.NzBecsDebit;
import org.openapitools.client.model.PadDebit;
import org.openapitools.client.model.PaypalAdaptive;
import org.openapitools.client.model.PaypalExpress;
import org.openapitools.client.model.PaypalExpressNative;
import org.openapitools.client.model.SepaDebit;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Payment method information.")
public class PaymentMethod {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_CUSTOM_TYPE = "custom_type";
    @SerializedName(value="custom_type")
    private String customType;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private Account account;
    public static final String SERIALIZED_NAME_BILLING_DETAILS = "billing_details";
    @SerializedName(value="billing_details")
    private BillingDetails billingDetails;
    public static final String SERIALIZED_NAME_MAXIMUM_PAYMENT_ATTEMPTS = "maximum_payment_attempts";
    @SerializedName(value="maximum_payment_attempts")
    private BigDecimal maximumPaymentAttempts;
    public static final String SERIALIZED_NAME_PAYMENT_RETRY_INTERVAL = "payment_retry_interval";
    @SerializedName(value="payment_retry_interval")
    private Integer paymentRetryInterval;
    public static final String SERIALIZED_NAME_DEVICE_SESSION_ID = "device_session_id";
    @SerializedName(value="device_session_id")
    private String deviceSessionId;
    public static final String SERIALIZED_NAME_IP_ADDRESS = "ip_address";
    @SerializedName(value="ip_address")
    private String ipAddress;
    public static final String SERIALIZED_NAME_BANK_IDENTIFICATION_NUMBER = "bank_identification_number";
    @SerializedName(value="bank_identification_number")
    private String bankIdentificationNumber;
    public static final String SERIALIZED_NAME_CARD = "card";
    @SerializedName(value="card")
    private GetCardList card;
    public static final String SERIALIZED_NAME_PAYPAL_EXPRESS_NATIVE = "paypal_express_native";
    @SerializedName(value="paypal_express_native")
    private PaypalExpressNative paypalExpressNative;
    public static final String SERIALIZED_NAME_PAYPAL_EXPRESS = "paypal_express";
    @SerializedName(value="paypal_express")
    private PaypalExpress paypalExpress;
    public static final String SERIALIZED_NAME_PAYPAL_ADAPTIVE = "paypal_adaptive";
    @SerializedName(value="paypal_adaptive")
    private PaypalAdaptive paypalAdaptive;
    public static final String SERIALIZED_NAME_SEPA_DEBIT = "sepa_debit";
    @SerializedName(value="sepa_debit")
    private SepaDebit sepaDebit;
    public static final String SERIALIZED_NAME_CC_REF = "cc_ref";
    @SerializedName(value="cc_ref")
    private CcRef ccRef;
    public static final String SERIALIZED_NAME_APPLE_PAY = "apple_pay";
    @SerializedName(value="apple_pay")
    private ApplePay applePay;
    public static final String SERIALIZED_NAME_GOOGLE_PAY = "google_pay";
    @SerializedName(value="google_pay")
    private GooglePay googlePay;
    public static final String SERIALIZED_NAME_ACH_DEBIT = "ach_debit";
    @SerializedName(value="ach_debit")
    private AchDebit achDebit;
    public static final String SERIALIZED_NAME_BETALINGS_DEBIT = "betalings_debit";
    @SerializedName(value="betalings_debit")
    private BetalingsDebit betalingsDebit;
    public static final String SERIALIZED_NAME_AUTOGIRO_DEBIT = "autogiro_debit";
    @SerializedName(value="autogiro_debit")
    private AutogiroDebit autogiroDebit;
    public static final String SERIALIZED_NAME_BACS_DEBIT = "bacs_debit";
    @SerializedName(value="bacs_debit")
    private BacsDebit bacsDebit;
    public static final String SERIALIZED_NAME_AU_BECS_DEBIT = "au_becs_debit";
    @SerializedName(value="au_becs_debit")
    private AuBecsDebit auBecsDebit;
    public static final String SERIALIZED_NAME_NZ_BECS_DEBIT = "nz_becs_debit";
    @SerializedName(value="nz_becs_debit")
    private NzBecsDebit nzBecsDebit;
    public static final String SERIALIZED_NAME_PAD_DEBIT = "pad_debit";
    @SerializedName(value="pad_debit")
    private PadDebit padDebit;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_AUTO_GENERATED = "auto_generated";
    @SerializedName(value="auto_generated")
    private Boolean autoGenerated;
    public static final String SERIALIZED_NAME_USE_DEFAULT_RETRY_RULE = "use_default_retry_rule";
    @SerializedName(value="use_default_retry_rule")
    private Boolean useDefaultRetryRule;
    public static final String SERIALIZED_NAME_EXISTING_MANDATE = "existing_mandate";
    @SerializedName(value="existing_mandate")
    private Boolean existingMandate;
    public static final String SERIALIZED_NAME_LAST_FAILED_SALE_TRANSACTION_TIME = "last_failed_sale_transaction_time";
    @SerializedName(value="last_failed_sale_transaction_time")
    private OffsetDateTime lastFailedSaleTransactionTime;
    public static final String SERIALIZED_NAME_LAST_TRANSACTION_TIME = "last_transaction_time";
    @SerializedName(value="last_transaction_time")
    private OffsetDateTime lastTransactionTime;
    public static final String SERIALIZED_NAME_LAST_TRANSACTION_STATUS = "last_transaction_status";
    @SerializedName(value="last_transaction_status")
    private String lastTransactionStatus;
    public static final String SERIALIZED_NAME_NUMBER_OF_CONSECUTIVE_FAILURES = "number_of_consecutive_failures";
    @SerializedName(value="number_of_consecutive_failures")
    private Integer numberOfConsecutiveFailures;
    public static final String SERIALIZED_NAME_TOTAL_NUMBER_OF_PROCESSED_PAYMENTS = "total_number_of_processed_payments";
    @SerializedName(value="total_number_of_processed_payments")
    private Integer totalNumberOfProcessedPayments;
    public static final String SERIALIZED_NAME_TOTAL_NUMBER_OF_ERROR_PAYMENTS = "total_number_of_error_payments";
    @SerializedName(value="total_number_of_error_payments")
    private Integer totalNumberOfErrorPayments;

    public PaymentMethod() {
    }

    public PaymentMethod(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, Account account) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.account = account;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public PaymentMethod customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PaymentMethod putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public PaymentMethod type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the payment method. An additional hash is included on the payment method with a name matching this value. It contains additional information specific to the payment method type.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PaymentMethod customType(String customType) {
        this.customType = customType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The custom type of the payment method from Universal Payment Connector.")
    public String getCustomType() {
        return this.customType;
    }

    public void setCustomType(String customType) {
        this.customType = customType;
    }

    public PaymentMethod accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="A customer account identifier.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @Nullable
    @ApiModelProperty(value="The customer account associated with this payment method.")
    public Account getAccount() {
        return this.account;
    }

    public PaymentMethod billingDetails(BillingDetails billingDetails) {
        this.billingDetails = billingDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BillingDetails getBillingDetails() {
        return this.billingDetails;
    }

    public void setBillingDetails(BillingDetails billingDetails) {
        this.billingDetails = billingDetails;
    }

    public PaymentMethod maximumPaymentAttempts(BigDecimal maximumPaymentAttempts) {
        this.maximumPaymentAttempts = maximumPaymentAttempts;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="6", value="Maximum number of consecutive failed retry payment attempts using this payment method before retries are stopped.")
    public BigDecimal getMaximumPaymentAttempts() {
        return this.maximumPaymentAttempts;
    }

    public void setMaximumPaymentAttempts(BigDecimal maximumPaymentAttempts) {
        this.maximumPaymentAttempts = maximumPaymentAttempts;
    }

    public PaymentMethod paymentRetryInterval(Integer paymentRetryInterval) {
        this.paymentRetryInterval = paymentRetryInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3", value="The retry interval in hours.")
    public Integer getPaymentRetryInterval() {
        return this.paymentRetryInterval;
    }

    public void setPaymentRetryInterval(Integer paymentRetryInterval) {
        this.paymentRetryInterval = paymentRetryInterval;
    }

    public PaymentMethod deviceSessionId(String deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getDeviceSessionId() {
        return this.deviceSessionId;
    }

    public void setDeviceSessionId(String deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
    }

    public PaymentMethod ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="192.10.1.123", value="The IP address from which the Mandate was accepted by the customer.")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public PaymentMethod bankIdentificationNumber(String bankIdentificationNumber) {
        this.bankIdentificationNumber = bankIdentificationNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getBankIdentificationNumber() {
        return this.bankIdentificationNumber;
    }

    public void setBankIdentificationNumber(String bankIdentificationNumber) {
        this.bankIdentificationNumber = bankIdentificationNumber;
    }

    public PaymentMethod card(GetCardList card) {
        this.card = card;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public GetCardList getCard() {
        return this.card;
    }

    public void setCard(GetCardList card) {
        this.card = card;
    }

    public PaymentMethod paypalExpressNative(PaypalExpressNative paypalExpressNative) {
        this.paypalExpressNative = paypalExpressNative;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaypalExpressNative getPaypalExpressNative() {
        return this.paypalExpressNative;
    }

    public void setPaypalExpressNative(PaypalExpressNative paypalExpressNative) {
        this.paypalExpressNative = paypalExpressNative;
    }

    public PaymentMethod paypalExpress(PaypalExpress paypalExpress) {
        this.paypalExpress = paypalExpress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaypalExpress getPaypalExpress() {
        return this.paypalExpress;
    }

    public void setPaypalExpress(PaypalExpress paypalExpress) {
        this.paypalExpress = paypalExpress;
    }

    public PaymentMethod paypalAdaptive(PaypalAdaptive paypalAdaptive) {
        this.paypalAdaptive = paypalAdaptive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaypalAdaptive getPaypalAdaptive() {
        return this.paypalAdaptive;
    }

    public void setPaypalAdaptive(PaypalAdaptive paypalAdaptive) {
        this.paypalAdaptive = paypalAdaptive;
    }

    public PaymentMethod sepaDebit(SepaDebit sepaDebit) {
        this.sepaDebit = sepaDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SepaDebit getSepaDebit() {
        return this.sepaDebit;
    }

    public void setSepaDebit(SepaDebit sepaDebit) {
        this.sepaDebit = sepaDebit;
    }

    public PaymentMethod ccRef(CcRef ccRef) {
        this.ccRef = ccRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CcRef getCcRef() {
        return this.ccRef;
    }

    public void setCcRef(CcRef ccRef) {
        this.ccRef = ccRef;
    }

    public PaymentMethod applePay(ApplePay applePay) {
        this.applePay = applePay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ApplePay getApplePay() {
        return this.applePay;
    }

    public void setApplePay(ApplePay applePay) {
        this.applePay = applePay;
    }

    public PaymentMethod googlePay(GooglePay googlePay) {
        this.googlePay = googlePay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public GooglePay getGooglePay() {
        return this.googlePay;
    }

    public void setGooglePay(GooglePay googlePay) {
        this.googlePay = googlePay;
    }

    public PaymentMethod achDebit(AchDebit achDebit) {
        this.achDebit = achDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AchDebit getAchDebit() {
        return this.achDebit;
    }

    public void setAchDebit(AchDebit achDebit) {
        this.achDebit = achDebit;
    }

    public PaymentMethod betalingsDebit(BetalingsDebit betalingsDebit) {
        this.betalingsDebit = betalingsDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BetalingsDebit getBetalingsDebit() {
        return this.betalingsDebit;
    }

    public void setBetalingsDebit(BetalingsDebit betalingsDebit) {
        this.betalingsDebit = betalingsDebit;
    }

    public PaymentMethod autogiroDebit(AutogiroDebit autogiroDebit) {
        this.autogiroDebit = autogiroDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AutogiroDebit getAutogiroDebit() {
        return this.autogiroDebit;
    }

    public void setAutogiroDebit(AutogiroDebit autogiroDebit) {
        this.autogiroDebit = autogiroDebit;
    }

    public PaymentMethod bacsDebit(BacsDebit bacsDebit) {
        this.bacsDebit = bacsDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BacsDebit getBacsDebit() {
        return this.bacsDebit;
    }

    public void setBacsDebit(BacsDebit bacsDebit) {
        this.bacsDebit = bacsDebit;
    }

    public PaymentMethod auBecsDebit(AuBecsDebit auBecsDebit) {
        this.auBecsDebit = auBecsDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AuBecsDebit getAuBecsDebit() {
        return this.auBecsDebit;
    }

    public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
        this.auBecsDebit = auBecsDebit;
    }

    public PaymentMethod nzBecsDebit(NzBecsDebit nzBecsDebit) {
        this.nzBecsDebit = nzBecsDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NzBecsDebit getNzBecsDebit() {
        return this.nzBecsDebit;
    }

    public void setNzBecsDebit(NzBecsDebit nzBecsDebit) {
        this.nzBecsDebit = nzBecsDebit;
    }

    public PaymentMethod padDebit(PadDebit padDebit) {
        this.padDebit = padDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PadDebit getPadDebit() {
        return this.padDebit;
    }

    public void setPadDebit(PadDebit padDebit) {
        this.padDebit = padDebit;
    }

    public PaymentMethod state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the payment method.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public PaymentMethod autoGenerated(Boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(Boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    public PaymentMethod useDefaultRetryRule(Boolean useDefaultRetryRule) {
        this.useDefaultRetryRule = useDefaultRetryRule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getUseDefaultRetryRule() {
        return this.useDefaultRetryRule;
    }

    public void setUseDefaultRetryRule(Boolean useDefaultRetryRule) {
        this.useDefaultRetryRule = useDefaultRetryRule;
    }

    public PaymentMethod existingMandate(Boolean existingMandate) {
        this.existingMandate = existingMandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getExistingMandate() {
        return this.existingMandate;
    }

    public void setExistingMandate(Boolean existingMandate) {
        this.existingMandate = existingMandate;
    }

    public PaymentMethod lastFailedSaleTransactionTime(OffsetDateTime lastFailedSaleTransactionTime) {
        this.lastFailedSaleTransactionTime = lastFailedSaleTransactionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getLastFailedSaleTransactionTime() {
        return this.lastFailedSaleTransactionTime;
    }

    public void setLastFailedSaleTransactionTime(OffsetDateTime lastFailedSaleTransactionTime) {
        this.lastFailedSaleTransactionTime = lastFailedSaleTransactionTime;
    }

    public PaymentMethod lastTransactionTime(OffsetDateTime lastTransactionTime) {
        this.lastTransactionTime = lastTransactionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getLastTransactionTime() {
        return this.lastTransactionTime;
    }

    public void setLastTransactionTime(OffsetDateTime lastTransactionTime) {
        this.lastTransactionTime = lastTransactionTime;
    }

    public PaymentMethod lastTransactionStatus(String lastTransactionStatus) {
        this.lastTransactionStatus = lastTransactionStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getLastTransactionStatus() {
        return this.lastTransactionStatus;
    }

    public void setLastTransactionStatus(String lastTransactionStatus) {
        this.lastTransactionStatus = lastTransactionStatus;
    }

    public PaymentMethod numberOfConsecutiveFailures(Integer numberOfConsecutiveFailures) {
        this.numberOfConsecutiveFailures = numberOfConsecutiveFailures;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getNumberOfConsecutiveFailures() {
        return this.numberOfConsecutiveFailures;
    }

    public void setNumberOfConsecutiveFailures(Integer numberOfConsecutiveFailures) {
        this.numberOfConsecutiveFailures = numberOfConsecutiveFailures;
    }

    public PaymentMethod totalNumberOfProcessedPayments(Integer totalNumberOfProcessedPayments) {
        this.totalNumberOfProcessedPayments = totalNumberOfProcessedPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getTotalNumberOfProcessedPayments() {
        return this.totalNumberOfProcessedPayments;
    }

    public void setTotalNumberOfProcessedPayments(Integer totalNumberOfProcessedPayments) {
        this.totalNumberOfProcessedPayments = totalNumberOfProcessedPayments;
    }

    public PaymentMethod totalNumberOfErrorPayments(Integer totalNumberOfErrorPayments) {
        this.totalNumberOfErrorPayments = totalNumberOfErrorPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getTotalNumberOfErrorPayments() {
        return this.totalNumberOfErrorPayments;
    }

    public void setTotalNumberOfErrorPayments(Integer totalNumberOfErrorPayments) {
        this.totalNumberOfErrorPayments = totalNumberOfErrorPayments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethod paymentMethod = (PaymentMethod)o;
        return Objects.equals(this.id, paymentMethod.id) && Objects.equals(this.updatedById, paymentMethod.updatedById) && Objects.equals(this.updatedTime, paymentMethod.updatedTime) && Objects.equals(this.createdById, paymentMethod.createdById) && Objects.equals(this.createdTime, paymentMethod.createdTime) && Objects.equals(this.customFields, paymentMethod.customFields) && Objects.equals(this.customObjects, paymentMethod.customObjects) && Objects.equals((Object)this.type, (Object)paymentMethod.type) && Objects.equals(this.customType, paymentMethod.customType) && Objects.equals(this.accountId, paymentMethod.accountId) && Objects.equals(this.account, paymentMethod.account) && Objects.equals(this.billingDetails, paymentMethod.billingDetails) && Objects.equals(this.maximumPaymentAttempts, paymentMethod.maximumPaymentAttempts) && Objects.equals(this.paymentRetryInterval, paymentMethod.paymentRetryInterval) && Objects.equals(this.deviceSessionId, paymentMethod.deviceSessionId) && Objects.equals(this.ipAddress, paymentMethod.ipAddress) && Objects.equals(this.bankIdentificationNumber, paymentMethod.bankIdentificationNumber) && Objects.equals(this.card, paymentMethod.card) && Objects.equals(this.paypalExpressNative, paymentMethod.paypalExpressNative) && Objects.equals(this.paypalExpress, paymentMethod.paypalExpress) && Objects.equals(this.paypalAdaptive, paymentMethod.paypalAdaptive) && Objects.equals(this.sepaDebit, paymentMethod.sepaDebit) && Objects.equals(this.ccRef, paymentMethod.ccRef) && Objects.equals(this.applePay, paymentMethod.applePay) && Objects.equals(this.googlePay, paymentMethod.googlePay) && Objects.equals(this.achDebit, paymentMethod.achDebit) && Objects.equals(this.betalingsDebit, paymentMethod.betalingsDebit) && Objects.equals(this.autogiroDebit, paymentMethod.autogiroDebit) && Objects.equals(this.bacsDebit, paymentMethod.bacsDebit) && Objects.equals(this.auBecsDebit, paymentMethod.auBecsDebit) && Objects.equals(this.nzBecsDebit, paymentMethod.nzBecsDebit) && Objects.equals(this.padDebit, paymentMethod.padDebit) && Objects.equals((Object)this.state, (Object)paymentMethod.state) && Objects.equals(this.autoGenerated, paymentMethod.autoGenerated) && Objects.equals(this.useDefaultRetryRule, paymentMethod.useDefaultRetryRule) && Objects.equals(this.existingMandate, paymentMethod.existingMandate) && Objects.equals(this.lastFailedSaleTransactionTime, paymentMethod.lastFailedSaleTransactionTime) && Objects.equals(this.lastTransactionTime, paymentMethod.lastTransactionTime) && Objects.equals(this.lastTransactionStatus, paymentMethod.lastTransactionStatus) && Objects.equals(this.numberOfConsecutiveFailures, paymentMethod.numberOfConsecutiveFailures) && Objects.equals(this.totalNumberOfProcessedPayments, paymentMethod.totalNumberOfProcessedPayments) && Objects.equals(this.totalNumberOfErrorPayments, paymentMethod.totalNumberOfErrorPayments);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.type, this.customType, this.accountId, this.account, this.billingDetails, this.maximumPaymentAttempts, this.paymentRetryInterval, this.deviceSessionId, this.ipAddress, this.bankIdentificationNumber, this.card, this.paypalExpressNative, this.paypalExpress, this.paypalAdaptive, this.sepaDebit, this.ccRef, this.applePay, this.googlePay, this.achDebit, this.betalingsDebit, this.autogiroDebit, this.bacsDebit, this.auBecsDebit, this.nzBecsDebit, this.padDebit, this.state, this.autoGenerated, this.useDefaultRetryRule, this.existingMandate, this.lastFailedSaleTransactionTime, this.lastTransactionTime, this.lastTransactionStatus, this.numberOfConsecutiveFailures, this.totalNumberOfProcessedPayments, this.totalNumberOfErrorPayments});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethod {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    customType: ").append(this.toIndentedString(this.customType)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    billingDetails: ").append(this.toIndentedString(this.billingDetails)).append("\n");
        sb.append("    maximumPaymentAttempts: ").append(this.toIndentedString(this.maximumPaymentAttempts)).append("\n");
        sb.append("    paymentRetryInterval: ").append(this.toIndentedString(this.paymentRetryInterval)).append("\n");
        sb.append("    deviceSessionId: ").append(this.toIndentedString(this.deviceSessionId)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    bankIdentificationNumber: ").append(this.toIndentedString(this.bankIdentificationNumber)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    paypalExpressNative: ").append(this.toIndentedString(this.paypalExpressNative)).append("\n");
        sb.append("    paypalExpress: ").append(this.toIndentedString(this.paypalExpress)).append("\n");
        sb.append("    paypalAdaptive: ").append(this.toIndentedString(this.paypalAdaptive)).append("\n");
        sb.append("    sepaDebit: ").append(this.toIndentedString(this.sepaDebit)).append("\n");
        sb.append("    ccRef: ").append(this.toIndentedString(this.ccRef)).append("\n");
        sb.append("    applePay: ").append(this.toIndentedString(this.applePay)).append("\n");
        sb.append("    googlePay: ").append(this.toIndentedString(this.googlePay)).append("\n");
        sb.append("    achDebit: ").append(this.toIndentedString(this.achDebit)).append("\n");
        sb.append("    betalingsDebit: ").append(this.toIndentedString(this.betalingsDebit)).append("\n");
        sb.append("    autogiroDebit: ").append(this.toIndentedString(this.autogiroDebit)).append("\n");
        sb.append("    bacsDebit: ").append(this.toIndentedString(this.bacsDebit)).append("\n");
        sb.append("    auBecsDebit: ").append(this.toIndentedString(this.auBecsDebit)).append("\n");
        sb.append("    nzBecsDebit: ").append(this.toIndentedString(this.nzBecsDebit)).append("\n");
        sb.append("    padDebit: ").append(this.toIndentedString(this.padDebit)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    autoGenerated: ").append(this.toIndentedString(this.autoGenerated)).append("\n");
        sb.append("    useDefaultRetryRule: ").append(this.toIndentedString(this.useDefaultRetryRule)).append("\n");
        sb.append("    existingMandate: ").append(this.toIndentedString(this.existingMandate)).append("\n");
        sb.append("    lastFailedSaleTransactionTime: ").append(this.toIndentedString(this.lastFailedSaleTransactionTime)).append("\n");
        sb.append("    lastTransactionTime: ").append(this.toIndentedString(this.lastTransactionTime)).append("\n");
        sb.append("    lastTransactionStatus: ").append(this.toIndentedString(this.lastTransactionStatus)).append("\n");
        sb.append("    numberOfConsecutiveFailures: ").append(this.toIndentedString(this.numberOfConsecutiveFailures)).append("\n");
        sb.append("    totalNumberOfProcessedPayments: ").append(this.toIndentedString(this.totalNumberOfProcessedPayments)).append("\n");
        sb.append("    totalNumberOfErrorPayments: ").append(this.toIndentedString(this.totalNumberOfErrorPayments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ACTIVE("active"),
        CLOSED("closed"),
        SCRUBBED("scrubbed"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PAYPAL_EXPRESS("paypal_express"),
        PAYPAL_EXPRESS_NATIVE("paypal_express_native"),
        PAYPAL_ADAPTIVE("paypal_adaptive"),
        CARD("card"),
        CC_REF("cc_ref"),
        ACH_DEBIT("ach_debit"),
        SEPA_DEBIT("sepa_debit"),
        BETALINGS_DEBIT("betalings_debit"),
        AUTOGIRO_DEBIT("autogiro_debit"),
        BACS_DEBIT("bacs_debit"),
        AU_BECS_DEBIT("au_becs_debit"),
        NZ_BECS_DEBIT("nz_becs_debit"),
        PAD_DEBIT("pad_debit"),
        APPLE_PAY("apple_pay"),
        WIRE_TRANSFER("wire_transfer"),
        CHECK("check"),
        CASH("cash"),
        OTHER("other"),
        PAYPAL("paypal"),
        ADYEN_GOOGLE_PAY("adyen_google_pay"),
        ADYEN_APPLE_PAY("adyen_apple_pay"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

