/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.CardMandate;

@ApiModel(description="Credit card information. When providing a card number, you must meet the requirements for PCI compliance. We strongly recommend using Zuora's [Payment Pages 2.0](https://knowledgecenter.zuora.com/Billing/Billing_and_Payments/LA_Hosted_Payment_Pages/B_Payment_Pages_2.0) instead of interacting with this API directly.")
public class Card {
    public static final String SERIALIZED_NAME_CARD_NUMBER = "card_number";
    @SerializedName(value="card_number")
    private String cardNumber;
    public static final String SERIALIZED_NAME_BRAND = "brand";
    @SerializedName(value="brand")
    private BrandEnum brand;
    public static final String SERIALIZED_NAME_EXPIRY_MONTH = "expiry_month";
    @SerializedName(value="expiry_month")
    private BigDecimal expiryMonth;
    public static final String SERIALIZED_NAME_EXPIRY_YEAR = "expiry_year";
    @SerializedName(value="expiry_year")
    private BigDecimal expiryYear;
    public static final String SERIALIZED_NAME_SECURITY_CODE = "security_code";
    @SerializedName(value="security_code")
    private String securityCode;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private CardMandate mandate;
    public static final String SERIALIZED_NAME_LAST4 = "last_4";
    @SerializedName(value="last_4")
    private String last4;

    public Card() {
    }

    public Card(String last4) {
        this();
        this.last4 = last4;
    }

    public Card cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="4001100010112042", required=true, value="The card number, as a string without any separators.")
    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public Card brand(BrandEnum brand) {
        this.brand = brand;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Card brand.")
    public BrandEnum getBrand() {
        return this.brand;
    }

    public void setBrand(BrandEnum brand) {
        this.brand = brand;
    }

    public Card expiryMonth(BigDecimal expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="10", required=true, value="One or two digit expiration month (1-12) of the credit card.")
    public BigDecimal getExpiryMonth() {
        return this.expiryMonth;
    }

    public void setExpiryMonth(BigDecimal expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public Card expiryYear(BigDecimal expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2024", required=true, value="Two- or four-digit number representing the card's expiration year.")
    public BigDecimal getExpiryYear() {
        return this.expiryYear;
    }

    public void setExpiryYear(BigDecimal expiryYear) {
        this.expiryYear = expiryYear;
    }

    public Card securityCode(String securityCode) {
        this.securityCode = securityCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="111", value="Card security code. It is highly recommended to always include this value.")
    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public Card mandate(CardMandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CardMandate getMandate() {
        return this.mandate;
    }

    public void setMandate(CardMandate mandate) {
        this.mandate = mandate;
    }

    @Nullable
    @ApiModelProperty(example="2042", value="The last four digits of the card number.")
    public String getLast4() {
        return this.last4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        return Objects.equals(this.cardNumber, card.cardNumber) && Objects.equals((Object)this.brand, (Object)card.brand) && Objects.equals(this.expiryMonth, card.expiryMonth) && Objects.equals(this.expiryYear, card.expiryYear) && Objects.equals(this.securityCode, card.securityCode) && Objects.equals(this.mandate, card.mandate) && Objects.equals(this.last4, card.last4);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cardNumber, this.brand, this.expiryMonth, this.expiryYear, this.securityCode, this.mandate, this.last4});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Card {\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString((Object)this.brand)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    securityCode: ").append(this.toIndentedString(this.securityCode)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("    last4: ").append(this.toIndentedString(this.last4)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BrandEnum {
        VISA("visa"),
        MASTERCARD("mastercard"),
        AMERICAN_EXPRESS("american_express"),
        DISCOVER("discover"),
        JCB("jcb"),
        DINERS("diners"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private BrandEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BrandEnum fromValue(String value) {
            for (BrandEnum b : BrandEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BrandEnum> {
            public void write(JsonWriter jsonWriter, BrandEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BrandEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BrandEnum.fromValue(value);
            }
        }
    }
}

