/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.BillingDocumentItemPaymentApplicationRequest;

public class BillingDocumentPaymentApplicationRequest {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_NUMBER = "billing_document_number";
    @SerializedName(value="billing_document_number")
    private String billingDocumentNumber;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<BillingDocumentItemPaymentApplicationRequest> items = null;

    public BillingDocumentPaymentApplicationRequest() {
    }

    public BillingDocumentPaymentApplicationRequest(String billingDocumentNumber) {
        this();
        this.billingDocumentNumber = billingDocumentNumber;
    }

    public BillingDocumentPaymentApplicationRequest id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifier of the billing document to which the credit memo, payment, or refund is applied.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BillingDocumentPaymentApplicationRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of billing document.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BillingDocumentPaymentApplicationRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The amount applied to this billing document.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Nullable
    @ApiModelProperty(value="A human-readable identifier for the billing document; may be user-supplied.")
    public String getBillingDocumentNumber() {
        return this.billingDocumentNumber;
    }

    public BillingDocumentPaymentApplicationRequest items(List<BillingDocumentItemPaymentApplicationRequest> items) {
        this.items = items;
        return this;
    }

    public BillingDocumentPaymentApplicationRequest addItemsItem(BillingDocumentItemPaymentApplicationRequest itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<BillingDocumentItemPaymentApplicationRequest>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing document items (invoice items or debit memo items or taxation items) to which the payment is applied.")
    public List<BillingDocumentItemPaymentApplicationRequest> getItems() {
        return this.items;
    }

    public void setItems(List<BillingDocumentItemPaymentApplicationRequest> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingDocumentPaymentApplicationRequest billingDocumentPaymentApplicationRequest = (BillingDocumentPaymentApplicationRequest)o;
        return Objects.equals(this.id, billingDocumentPaymentApplicationRequest.id) && Objects.equals((Object)this.type, (Object)billingDocumentPaymentApplicationRequest.type) && Objects.equals(this.amount, billingDocumentPaymentApplicationRequest.amount) && Objects.equals(this.billingDocumentNumber, billingDocumentPaymentApplicationRequest.billingDocumentNumber) && Objects.equals(this.items, billingDocumentPaymentApplicationRequest.items);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.amount, this.billingDocumentNumber, this.items});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingDocumentPaymentApplicationRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    billingDocumentNumber: ").append(this.toIndentedString(this.billingDocumentNumber)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        DEBIT_MEMO("debit_memo"),
        INVOICE("invoice"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

