/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;

public class GenerateBillingDocumentsAccountRequest {
    public static final String SERIALIZED_NAME_POST = "post";
    @SerializedName(value="post")
    private Boolean post;
    public static final String SERIALIZED_NAME_RENEW = "renew";
    @SerializedName(value="renew")
    private Boolean renew;
    public static final String SERIALIZED_NAME_CHARGES_EXCLUDED = "charges_excluded";
    @SerializedName(value="charges_excluded")
    private List<String> chargesExcluded = null;
    public static final String SERIALIZED_NAME_CREDIT_MEMO_REASON_CODE = "credit_memo_reason_code";
    @SerializedName(value="credit_memo_reason_code")
    private String creditMemoReasonCode;
    public static final String SERIALIZED_NAME_DOCUMENT_DATE = "document_date";
    @SerializedName(value="document_date")
    private LocalDate documentDate;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_IDS = "subscription_ids";
    @SerializedName(value="subscription_ids")
    private List<String> subscriptionIds = null;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;

    public GenerateBillingDocumentsAccountRequest post(Boolean post) {
        this.post = post;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="If true, invoices will be automatically posted.")
    public Boolean getPost() {
        return this.post;
    }

    public void setPost(Boolean post) {
        this.post = post;
    }

    public GenerateBillingDocumentsAccountRequest renew(Boolean renew) {
        this.renew = renew;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="If true, subscriptions will be automatically renewed.")
    public Boolean getRenew() {
        return this.renew;
    }

    public void setRenew(Boolean renew) {
        this.renew = renew;
    }

    public GenerateBillingDocumentsAccountRequest chargesExcluded(List<String> chargesExcluded) {
        this.chargesExcluded = chargesExcluded;
        return this;
    }

    public GenerateBillingDocumentsAccountRequest addChargesExcludedItem(String chargesExcludedItem) {
        if (this.chargesExcluded == null) {
            this.chargesExcluded = new ArrayList<String>();
        }
        this.chargesExcluded.add(chargesExcludedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Charge type or types to be excluded. Can be `one_time`,`recurring`, or `usage`.")
    public List<String> getChargesExcluded() {
        return this.chargesExcluded;
    }

    public void setChargesExcluded(List<String> chargesExcluded) {
        this.chargesExcluded = chargesExcluded;
    }

    public GenerateBillingDocumentsAccountRequest creditMemoReasonCode(String creditMemoReasonCode) {
        this.creditMemoReasonCode = creditMemoReasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A code identifying the reason for the credit memo transaction that is generated by the request. The value must be an existing reason code. If you do not pass the field or pass the field with empty value, Zuora uses the default reason code.")
    public String getCreditMemoReasonCode() {
        return this.creditMemoReasonCode;
    }

    public void setCreditMemoReasonCode(String creditMemoReasonCode) {
        this.creditMemoReasonCode = creditMemoReasonCode;
    }

    public GenerateBillingDocumentsAccountRequest documentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date when the credit memo is applied")
    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
    }

    public GenerateBillingDocumentsAccountRequest subscriptionIds(List<String> subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
        return this;
    }

    public GenerateBillingDocumentsAccountRequest addSubscriptionIdsItem(String subscriptionIdsItem) {
        if (this.subscriptionIds == null) {
            this.subscriptionIds = new ArrayList<String>();
        }
        this.subscriptionIds.add(subscriptionIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The IDs of the subscriptions that you want to create the billing documents for. Each value must be the unique identifier of the latest version of an active subscription.")
    public List<String> getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public void setSubscriptionIds(List<String> subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
    }

    public GenerateBillingDocumentsAccountRequest targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="All unbilled items on or before this date are included.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateBillingDocumentsAccountRequest generateBillingDocumentsAccountRequest = (GenerateBillingDocumentsAccountRequest)o;
        return Objects.equals(this.post, generateBillingDocumentsAccountRequest.post) && Objects.equals(this.renew, generateBillingDocumentsAccountRequest.renew) && Objects.equals(this.chargesExcluded, generateBillingDocumentsAccountRequest.chargesExcluded) && Objects.equals(this.creditMemoReasonCode, generateBillingDocumentsAccountRequest.creditMemoReasonCode) && Objects.equals(this.documentDate, generateBillingDocumentsAccountRequest.documentDate) && Objects.equals(this.subscriptionIds, generateBillingDocumentsAccountRequest.subscriptionIds) && Objects.equals(this.targetDate, generateBillingDocumentsAccountRequest.targetDate);
    }

    public int hashCode() {
        return Objects.hash(this.post, this.renew, this.chargesExcluded, this.creditMemoReasonCode, this.documentDate, this.subscriptionIds, this.targetDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenerateBillingDocumentsAccountRequest {\n");
        sb.append("    post: ").append(this.toIndentedString(this.post)).append("\n");
        sb.append("    renew: ").append(this.toIndentedString(this.renew)).append("\n");
        sb.append("    chargesExcluded: ").append(this.toIndentedString(this.chargesExcluded)).append("\n");
        sb.append("    creditMemoReasonCode: ").append(this.toIndentedString(this.creditMemoReasonCode)).append("\n");
        sb.append("    documentDate: ").append(this.toIndentedString(this.documentDate)).append("\n");
        sb.append("    subscriptionIds: ").append(this.toIndentedString(this.subscriptionIds)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

