/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.GetSubscriptionChangeLogResponse;
import com.zuora.model.GetSubscriptionChangeLogsResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SubscriptionChangeLogsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SubscriptionChangeLogsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionChangeLogsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getSubscriptionChangeLogsByOrderNumberCall(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/subscription-change-logs/orders/{orderNumber}".replace("{orderNumber}", this.localVarApiClient.escapeString(orderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionChangeLogsByOrderNumberValidateBeforeCall(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderNumber == null) {
            throw new ApiException("Missing the required parameter 'orderNumber' when calling getSubscriptionChangeLogsByOrderNumber(Async)");
        }
        return this.getSubscriptionChangeLogsByOrderNumberCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetSubscriptionChangeLogsResponse getSubscriptionChangeLogsByOrderNumber(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetSubscriptionChangeLogsResponse> localVarResp = this.getSubscriptionChangeLogsByOrderNumberWithHttpInfo(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetSubscriptionChangeLogsResponse> getSubscriptionChangeLogsByOrderNumberWithHttpInfo(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionChangeLogsByOrderNumberValidateBeforeCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetSubscriptionChangeLogsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getSubscriptionChangeLogsByOrderNumberAsync(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetSubscriptionChangeLogsResponse> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionChangeLogsByOrderNumberValidateBeforeCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetSubscriptionChangeLogsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionChangeLogsByOrderNumberApi getSubscriptionChangeLogsByOrderNumberApi(String orderNumber) {
        return new GetSubscriptionChangeLogsByOrderNumberApi(orderNumber);
    }

    private Call getSubscriptionChangeLogsBySubscriptionNumberCall(String subscriptionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/subscription-change-logs/{subscriptionNumber}".replace("{subscriptionNumber}", this.localVarApiClient.escapeString(subscriptionNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionChangeLogsBySubscriptionNumberValidateBeforeCall(String subscriptionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionNumber == null) {
            throw new ApiException("Missing the required parameter 'subscriptionNumber' when calling getSubscriptionChangeLogsBySubscriptionNumber(Async)");
        }
        return this.getSubscriptionChangeLogsBySubscriptionNumberCall(subscriptionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetSubscriptionChangeLogsResponse getSubscriptionChangeLogsBySubscriptionNumber(String subscriptionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetSubscriptionChangeLogsResponse> localVarResp = this.getSubscriptionChangeLogsBySubscriptionNumberWithHttpInfo(subscriptionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetSubscriptionChangeLogsResponse> getSubscriptionChangeLogsBySubscriptionNumberWithHttpInfo(String subscriptionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionChangeLogsBySubscriptionNumberValidateBeforeCall(subscriptionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetSubscriptionChangeLogsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getSubscriptionChangeLogsBySubscriptionNumberAsync(String subscriptionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetSubscriptionChangeLogsResponse> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionChangeLogsBySubscriptionNumberValidateBeforeCall(subscriptionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetSubscriptionChangeLogsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionChangeLogsBySubscriptionNumberApi getSubscriptionChangeLogsBySubscriptionNumberApi(String subscriptionNumber) {
        return new GetSubscriptionChangeLogsBySubscriptionNumberApi(subscriptionNumber);
    }

    private Call getSubscriptionChangeLogsBySubscriptionNumberAndVersionCall(String subscriptionNumber, String version, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/subscription-change-logs/{subscriptionNumber}/versions/{version}".replace("{subscriptionNumber}", this.localVarApiClient.escapeString(subscriptionNumber.toString())).replace("{version}", this.localVarApiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionChangeLogsBySubscriptionNumberAndVersionValidateBeforeCall(String subscriptionNumber, String version, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionNumber == null) {
            throw new ApiException("Missing the required parameter 'subscriptionNumber' when calling getSubscriptionChangeLogsBySubscriptionNumberAndVersion(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getSubscriptionChangeLogsBySubscriptionNumberAndVersion(Async)");
        }
        return this.getSubscriptionChangeLogsBySubscriptionNumberAndVersionCall(subscriptionNumber, version, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetSubscriptionChangeLogResponse getSubscriptionChangeLogsBySubscriptionNumberAndVersion(String subscriptionNumber, String version, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetSubscriptionChangeLogResponse> localVarResp = this.getSubscriptionChangeLogsBySubscriptionNumberAndVersionWithHttpInfo(subscriptionNumber, version, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetSubscriptionChangeLogResponse> getSubscriptionChangeLogsBySubscriptionNumberAndVersionWithHttpInfo(String subscriptionNumber, String version, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionChangeLogsBySubscriptionNumberAndVersionValidateBeforeCall(subscriptionNumber, version, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetSubscriptionChangeLogResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getSubscriptionChangeLogsBySubscriptionNumberAndVersionAsync(String subscriptionNumber, String version, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetSubscriptionChangeLogResponse> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionChangeLogsBySubscriptionNumberAndVersionValidateBeforeCall(subscriptionNumber, version, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetSubscriptionChangeLogResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi getSubscriptionChangeLogsBySubscriptionNumberAndVersionApi(String subscriptionNumber, String version) {
        return new GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi(subscriptionNumber, version);
    }

    public class GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi {
        private final String subscriptionNumber;
        private final String version;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi(String subscriptionNumber, String version) {
            this.subscriptionNumber = subscriptionNumber;
            this.version = version;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberAndVersionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsBySubscriptionNumberAndVersionCall(this.subscriptionNumber, this.version, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetSubscriptionChangeLogResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsBySubscriptionNumberAndVersionWithHttpInfo(this.subscriptionNumber, this.version, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (GetSubscriptionChangeLogResponse)localVarResp.getData();
        }

        private ApiResponse<GetSubscriptionChangeLogResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsBySubscriptionNumberAndVersionWithHttpInfo(this.subscriptionNumber, this.version, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetSubscriptionChangeLogResponse> _callback) throws ApiException {
            return SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsBySubscriptionNumberAndVersionAsync(this.subscriptionNumber, this.version, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetSubscriptionChangeLogsBySubscriptionNumberApi {
        private final String subscriptionNumber;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetSubscriptionChangeLogsBySubscriptionNumberApi(String subscriptionNumber) {
            this.subscriptionNumber = subscriptionNumber;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetSubscriptionChangeLogsBySubscriptionNumberApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsBySubscriptionNumberCall(this.subscriptionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetSubscriptionChangeLogsResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsBySubscriptionNumberWithHttpInfo(this.subscriptionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (GetSubscriptionChangeLogsResponse)localVarResp.getData();
        }

        private ApiResponse<GetSubscriptionChangeLogsResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsBySubscriptionNumberWithHttpInfo(this.subscriptionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetSubscriptionChangeLogsResponse> _callback) throws ApiException {
            return SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsBySubscriptionNumberAsync(this.subscriptionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetSubscriptionChangeLogsByOrderNumberApi {
        private final String orderNumber;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetSubscriptionChangeLogsByOrderNumberApi(String orderNumber) {
            this.orderNumber = orderNumber;
        }

        public GetSubscriptionChangeLogsByOrderNumberApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetSubscriptionChangeLogsByOrderNumberApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetSubscriptionChangeLogsByOrderNumberApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetSubscriptionChangeLogsByOrderNumberApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetSubscriptionChangeLogsByOrderNumberApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetSubscriptionChangeLogsByOrderNumberApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetSubscriptionChangeLogsByOrderNumberApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsByOrderNumberCall(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetSubscriptionChangeLogsResponse execute() throws ApiException {
            ApiResponse localVarResp = SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsByOrderNumberWithHttpInfo(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (GetSubscriptionChangeLogsResponse)localVarResp.getData();
        }

        private ApiResponse<GetSubscriptionChangeLogsResponse> executeWithHttpInfo() throws ApiException {
            return SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsByOrderNumberWithHttpInfo(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetSubscriptionChangeLogsResponse> _callback) throws ApiException {
            return SubscriptionChangeLogsApi.this.getSubscriptionChangeLogsByOrderNumberAsync(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

